/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import java.util.TooManyListenersException;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import org.apache.log4j.Logger;
import test.tck.TckInternalError;
import test.tck.msgflow.MessageFlowHarness;

class SipEventCollector {
    private static long MESSAGE_QUEUE_EMPTIES_FOR = 500L;
    private RequestCollector requestCollector = null;
    private ResponseCollector responseCollector = null;
    private TimeoutCollector timeoutCollector = null;
    private DialogTerminationCollector dialogTerminationCollector = null;
    private TransactionTerminationCollector transactionTerminationCollector = null;
    private static Logger logger = Logger.getLogger(SipEventCollector.class);

    SipEventCollector() {
    }

    private void initCollectors(SipProvider sipProvider) {
        this.requestCollector = new RequestCollector(sipProvider);
        this.responseCollector = new ResponseCollector(sipProvider);
        this.timeoutCollector = new TimeoutCollector(sipProvider);
        this.dialogTerminationCollector = new DialogTerminationCollector(sipProvider);
        this.transactionTerminationCollector = new TransactionTerminationCollector(sipProvider);
    }

    public void collectRequestEvent(SipProvider provider) throws TooManyListenersException {
        this.initCollectors(provider);
        provider.addSipListener((SipListener)this.requestCollector);
    }

    public void collectResponseEvent(SipProvider provider) throws TooManyListenersException {
        this.initCollectors(provider);
        provider.addSipListener((SipListener)this.responseCollector);
    }

    public void collectTimeoutEvent(SipProvider provider) throws TooManyListenersException {
        this.initCollectors(provider);
        provider.addSipListener((SipListener)this.timeoutCollector);
    }

    public void collectTransactionTermiatedEvent(SipProvider provider) throws TooManyListenersException {
        this.initCollectors(provider);
        provider.addSipListener((SipListener)this.transactionTerminationCollector);
    }

    public void collectDialogTermiatedEvent(SipProvider provider) throws TooManyListenersException {
        this.initCollectors(provider);
        provider.addSipListener((SipListener)this.dialogTerminationCollector);
    }

    public RequestEvent extractCollectedRequestEvent() {
        return this.extractCollectedRequestEvent(true);
    }

    public RequestEvent extractCollectedRequestEvent(boolean toReset) {
        if (this.requestCollector == null) {
            throw new TckInternalError("A request collect was attempted when the requestCollector was null");
        }
        RequestEvent collectedEvent = this.requestCollector.collectedEvent;
        if (toReset) {
            this.requestCollector.provider.removeSipListener((SipListener)this.requestCollector);
            this.resetCollectors();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return collectedEvent;
    }

    public ResponseEvent extractCollectedResponseEvent() {
        if (this.responseCollector == null) {
            throw new TckInternalError("A response collect was attempted when the responseCollector was null");
        }
        ResponseEvent collectedEvent = this.responseCollector.collectedEvent;
        this.responseCollector.provider.removeSipListener((SipListener)this.responseCollector);
        this.resetCollectors();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return collectedEvent;
    }

    public TimeoutEvent extractCollectedTimeoutEvent() {
        if (this.timeoutCollector == null) {
            throw new TckInternalError("A timeout collect was attempted when the timeoutCollector was null");
        }
        TimeoutEvent collectedEvent = this.timeoutCollector.collectedEvent;
        this.timeoutCollector.provider.removeSipListener((SipListener)this.timeoutCollector);
        this.resetCollectors();
        return collectedEvent;
    }

    public DialogTerminatedEvent extractCollectedDialogTerminatedEvent() {
        if (this.dialogTerminationCollector == null) {
            throw new TckInternalError("A dialog-terminated collect was attempted when the dialogTerminationCollector was null");
        }
        DialogTerminatedEvent collectedEvent = this.dialogTerminationCollector.collectedEvent;
        this.dialogTerminationCollector.provider.removeSipListener((SipListener)this.dialogTerminationCollector);
        this.resetCollectors();
        return collectedEvent;
    }

    public TransactionTerminatedEvent extractCollectedTransactionTerminatedEvent() {
        if (this.transactionTerminationCollector == null) {
            throw new TckInternalError("A timeout collect was attempted when the transactionTerminationCollector was null");
        }
        TransactionTerminatedEvent collectedEvent = this.transactionTerminationCollector.collectedEvent;
        this.transactionTerminationCollector.provider.removeSipListener((SipListener)this.transactionTerminationCollector);
        this.resetCollectors();
        return collectedEvent;
    }

    private void resetCollectors() {
        MessageFlowHarness.sleep(MESSAGE_QUEUE_EMPTIES_FOR);
    }

    private void assertInitialState(Class eventClass) {
        boolean failureFlag = false;
        if (eventClass.equals(RequestEvent.class)) {
            if (this.requestCollector != null && this.requestCollector.collectedEvent != null) {
                failureFlag = true;
            }
        } else if (eventClass.equals(ResponseEvent.class)) {
            if (this.responseCollector != null && this.responseCollector.collectedEvent != null) {
                failureFlag = true;
            }
        } else if (eventClass.equals(TimeoutEvent.class)) {
            if (this.timeoutCollector != null && this.timeoutCollector.collectedEvent != null) {
                failureFlag = true;
            }
        } else if (eventClass.equals(TransactionTerminatedEvent.class)) {
            if (this.transactionTerminationCollector != null && this.transactionTerminationCollector.collectedEvent != null) {
                failureFlag = true;
            }
        } else if (eventClass.equals(DialogTerminatedEvent.class) && this.dialogTerminationCollector != null && this.dialogTerminationCollector.collectedEvent != null) {
            failureFlag = true;
        }
        if (failureFlag) {
            throw new TckInternalError("Attempting to start a collect operation on a collector that is not in initial state!");
        }
    }

    private class TimeoutCollector
    implements SipListener {
        private TimeoutEvent collectedEvent = null;
        private SipProvider provider;

        public TimeoutCollector(SipProvider sipProvider) {
            this.provider = sipProvider;
        }

        public void processRequest(RequestEvent requestEvent) {
            SipEventCollector.this.requestCollector.processRequest(requestEvent);
        }

        public void processResponse(ResponseEvent responseEvent) {
        }

        public void processTimeout(TimeoutEvent evt) {
            if (this.collectedEvent != null || evt == null) {
                return;
            }
            this.collectedEvent = evt;
        }

        public void processIOException(IOExceptionEvent exceptionEvent) {
            logger.info((Object)"processIOException");
        }

        public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
            logger.info((Object)"processTransactionTerminated");
        }

        public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
            logger.info((Object)"processDialogTerminated");
        }
    }

    private class DialogTerminationCollector
    implements SipListener {
        private DialogTerminatedEvent collectedEvent;
        private SipProvider provider;

        public DialogTerminationCollector(SipProvider sipProvider) {
            this.provider = sipProvider;
        }

        public void processRequest(RequestEvent requestEvent) {
        }

        public void processResponse(ResponseEvent responseEvent) {
        }

        public void processTimeout(TimeoutEvent timeoutEvent) {
        }

        public void processIOException(IOExceptionEvent exceptionEvent) {
        }

        public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        }

        public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
            this.collectedEvent = dialogTerminatedEvent;
        }
    }

    private class TransactionTerminationCollector
    implements SipListener {
        private TransactionTerminatedEvent collectedEvent;
        private SipProvider provider;

        public TransactionTerminationCollector(SipProvider sipProvider) {
            this.provider = sipProvider;
        }

        public void processRequest(RequestEvent requestEvent) {
        }

        public void processResponse(ResponseEvent responseEvent) {
        }

        public void processTimeout(TimeoutEvent timeoutEvent) {
        }

        public void processIOException(IOExceptionEvent exceptionEvent) {
        }

        public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
            this.collectedEvent = transactionTerminatedEvent;
        }

        public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        }
    }

    private class ResponseCollector
    implements SipListener {
        private ResponseEvent collectedEvent = null;
        private SipProvider provider;

        public ResponseCollector(SipProvider sipProvider) {
            this.provider = sipProvider;
        }

        public void processRequest(RequestEvent requestEvent) {
        }

        public void processResponse(ResponseEvent evt) {
            if (this.collectedEvent != null || evt == null) {
                return;
            }
            this.collectedEvent = evt;
        }

        public void processTimeout(TimeoutEvent timeoutEvent) {
            logger.debug((Object)"processTimeout");
        }

        public void processIOException(IOExceptionEvent exceptionEvent) {
            logger.error((Object)"processIOException");
        }

        public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
            logger.info((Object)"transaction terminated event recieved");
        }

        public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
            logger.info((Object)"processDialogTerminated");
        }
    }

    private class RequestCollector
    implements SipListener {
        private RequestEvent collectedEvent = null;
        private SipProvider provider;

        public RequestCollector(SipProvider sipProvider) {
            this.provider = sipProvider;
        }

        public void processRequest(RequestEvent evt) {
            if (this.collectedEvent != null || evt == null) {
                return;
            }
            this.collectedEvent = evt;
        }

        public void processResponse(ResponseEvent responseEvent) {
        }

        public void processTimeout(TimeoutEvent timeoutEvent) {
        }

        public void processIOException(IOExceptionEvent exceptionEvent) {
            logger.debug((Object)"processIOException");
        }

        public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
            logger.debug((Object)"processTransactionTerminated");
        }

        public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
            logger.debug((Object)"processDialogTerminated");
        }
    }
}

