/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import java.text.ParseException;
import java.util.LinkedList;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import junit.framework.Test;
import junit.framework.TestSuite;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.msgflow.MessageFlowHarness;

public class SipProviderTest
extends MessageFlowHarness {
    public SipProviderTest(String name) {
        super(name, true);
    }

    public void testSendRequest() {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            Object receivedRequest = null;
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                SipProviderTest.waitForMessage();
                this.tiSipProvider.sendRequest(invite);
                SipProviderTest.waitForMessage();
                RequestEvent receivedRequestEvent = this.eventCollector.extractCollectedRequestEvent();
                SipProviderTest.assertNotNull("The sent request was not received at the other end!", receivedRequestEvent);
                SipProviderTest.assertNotNull("The sent request was not received at the other end!", receivedRequestEvent.getRequest());
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("The following exception was thrown while trying to add a SipListener to an RI SipProvider", ex);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                SipProviderTest.fail("A SipException exception was thrown while trying to send a request.");
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            SipProviderTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        SipProviderTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testSendNullRequest() {
        try {
            try {
                Request nullRequest = riMessageFactory.createRequest("");
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(nullRequest);
                SipProviderTest.waitForMessage();
                RequestEvent receivedRequestEvent = this.eventCollector.extractCollectedRequestEvent();
                if (receivedRequestEvent != null) {
                    throw new TiUnexpectedError("The the sent null string request should not generate a request event!");
                }
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("A TooManyListenersException was thrown while trying to add a SipListener to a TI SipProvider.", ex);
            }
            catch (SipException ex) {
                throw new TckInternalError("The RI failed to send the request!", ex);
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("The null request did not parse and create an empty message!");
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            SipProviderTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        SipProviderTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testReceiveRequest() {
        try {
            Request invite = this.createRiInviteRequest(null, null, null);
            RequestEvent receivedRequestEvent = null;
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(invite);
                SipProviderTest.waitForMessage();
                receivedRequestEvent = this.eventCollector.extractCollectedRequestEvent();
                SipProviderTest.assertNotNull("The sent request was not received at the other end!", receivedRequestEvent);
                SipProviderTest.assertNotNull("The sent request was not received at the other end!", receivedRequestEvent.getRequest());
            }
            catch (TooManyListenersException ex) {
                ex.printStackTrace();
                SipProviderTest.fail("A TooManyListenersException was thrown while trying to add a SipListener to a TI SipProvider.");
            }
            catch (SipException ex) {
                throw new TckInternalError("The RI failed to send the request!", ex);
            }
            SipProviderTest.assertNull("The Tested Implementation has implicitly created a ServerTransaction for the received request. Transactions should only be created explicitly using the SipProvider.getNewXxxTransaction() method.", receivedRequestEvent.getServerTransaction());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            SipProviderTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        SipProviderTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testReceiveACK() {
        try {
            Request ack = this.createRiInviteRequest(null, null, null);
            ack.setMethod("ACK");
            RequestEvent receivedRequestEvent = null;
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(ack);
                SipProviderTest.waitForMessage();
                receivedRequestEvent = this.eventCollector.extractCollectedRequestEvent();
                SipProviderTest.assertNotNull("The sent ACK event was not received at the other end!", receivedRequestEvent);
                SipProviderTest.assertNotNull("The sent ACK was not received at the other end!", receivedRequestEvent.getRequest());
            }
            catch (TooManyListenersException ex) {
                ex.printStackTrace();
                SipProviderTest.fail("A TooManyListenersException was thrown while trying to add a SipListener to a TI SipProvider.");
            }
            catch (SipException ex) {
                throw new TckInternalError("The RI failed to send the request!", ex);
            }
            SipProviderTest.assertNull("The Tested Implementation has implicitly created a ServerTransaction for the received request. Transactions should only be created explicitly using the SipProvider.getNewXxxTransaction() method.", receivedRequestEvent.getServerTransaction());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            SipProviderTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        SipProviderTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testSendResponse() {
        try {
            Request invite = this.createRiInviteRequest(null, null, null);
            RequestEvent receivedRequestEvent = null;
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(invite);
                SipProviderTest.waitForMessage();
                receivedRequestEvent = this.eventCollector.extractCollectedRequestEvent();
                if (receivedRequestEvent == null || receivedRequestEvent.getRequest() == null) {
                    throw new TiUnexpectedError("The sent request was not received by the RI!");
                }
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("A TooManyListenersException was thrown while trying to add a SipListener to a TI SipProvider.", ex);
            }
            catch (SipException ex) {
                throw new TckInternalError("The RI failed to send the request!", ex);
            }
            Request receivedRequest = receivedRequestEvent.getRequest();
            LinkedList<Header> via = new LinkedList<Header>();
            via.add(receivedRequest.getHeader("Via"));
            Response ok = null;
            try {
                ok = tiMessageFactory.createResponse(200, (CallIdHeader)receivedRequest.getHeader("Call-ID"), (CSeqHeader)receivedRequest.getHeader("CSeq"), (FromHeader)receivedRequest.getHeader("From"), (ToHeader)receivedRequest.getHeader("To"), via, (MaxForwardsHeader)receivedRequest.getHeader("Max-Forwards"));
                ((ToHeader)ok.getHeader("To")).setTag("ok");
                this.addStatus(receivedRequest, ok);
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("Failed to create an OK response!", ex);
            }
            try {
                this.eventCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Error while trying to add riSipProvider");
            }
            try {
                this.tiSipProvider.sendResponse(ok);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                SipProviderTest.fail("A SipException occurred while trying to send an ok response.");
            }
            SipProviderTest.waitForMessage();
            ResponseEvent responseEvent = this.eventCollector.extractCollectedResponseEvent();
            SipProviderTest.assertNotNull("The sent response was not received by the RI!", responseEvent);
            SipProviderTest.assertNotNull("The sent response was not received by the RI!", responseEvent.getResponse());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            SipProviderTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        SipProviderTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testReceiveResponse() {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            RequestEvent receivedRequestEvent = null;
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                this.tiSipProvider.sendRequest(invite);
                SipProviderTest.waitForMessage();
                receivedRequestEvent = this.eventCollector.extractCollectedRequestEvent();
                if (receivedRequestEvent == null || receivedRequestEvent.getRequest() == null) {
                    throw new TckInternalError("The sent request was not received by the RI!");
                }
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("A TooManyListenersException was thrown while trying to add a SipListener to an RI SipProvider.", ex);
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("The TI failed to send the request!", ex);
            }
            Request receivedRequest = receivedRequestEvent.getRequest();
            Response ok = null;
            try {
                ok = riMessageFactory.createResponse(200, receivedRequest);
                ((ToHeader)ok.getHeader("To")).setTag("ok");
                this.addStatus(receivedRequest, ok);
            }
            catch (ParseException ex) {
                throw new TckInternalError("Failed to create an OK response!", ex);
            }
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Error while trying to add riSipProvider");
            }
            try {
                this.riSipProvider.sendResponse(ok);
            }
            catch (SipException ex) {
                throw new TckInternalError("Could not send back the response", ex);
            }
            SipProviderTest.waitForMessage();
            ResponseEvent responseEvent = this.eventCollector.extractCollectedResponseEvent();
            SipProviderTest.assertNotNull("The TI failed to receive the response!", responseEvent);
            SipProviderTest.assertNotNull("The TI failed to receive the response!", responseEvent.getResponse());
            SipProviderTest.assertNull("The TI had implicitly created a client transaction! Transactions should only be created explicitly using the SipProvider.getNewXxxTransaction() method.", responseEvent.getClientTransaction());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            SipProviderTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        SipProviderTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testGetNewClientTransaction() {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewClientTransaction(invite);
            }
            catch (TransactionUnavailableException exc) {
                exc.printStackTrace();
                SipProviderTest.fail("A TransactionUnavailableException was thrown while trying to create a new client transaction");
            }
            SipProviderTest.assertNotNull("A null ClientTransaction was returned by SipProvider.getNewClientTransaction().", tran);
            String tranBranch = tran.getBranchId();
            String reqBranch = ((ViaHeader)invite.getHeader("Via")).getBranch();
            SipProviderTest.assertEquals("The newly created transaction did not have the same branch id as the request that created it", tranBranch, reqBranch);
            SipProviderTest.assertNotNull("The transaction's getRequest() method returned a null Request ", tran.getRequest());
            SipProviderTest.assertEquals("The transaction's getRequest() method returned a Request that did not match the one that we used to create it!", tran.getRequest(), invite);
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            SipProviderTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        SipProviderTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testGetNewServerTransaction() {
        try {
            Request invite = this.createRiInviteRequest(null, null, null);
            ServerTransaction tran = null;
            RequestEvent receivedRequestEvent = null;
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(invite);
                SipProviderTest.waitForMessage();
                receivedRequestEvent = this.eventCollector.extractCollectedRequestEvent();
                if (receivedRequestEvent == null || receivedRequestEvent.getRequest() == null) {
                    throw new TiUnexpectedError("The sent request was not received by the RI!");
                }
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("A TooManyListenersException was thrown while trying to add a SipListener to a TI SipProvider.", ex);
            }
            catch (SipException ex) {
                throw new TckInternalError("The RI failed to send the request!", ex);
            }
            try {
                tran = this.tiSipProvider.getNewServerTransaction(receivedRequestEvent.getRequest());
            }
            catch (TransactionUnavailableException exc) {
                exc.printStackTrace();
                SipProviderTest.fail("A TransactionUnavailableException was thrown while trying to create a new client transaction");
            }
            catch (TransactionAlreadyExistsException exc) {
                exc.printStackTrace();
                SipProviderTest.fail("A TransactionAlreadyExistsException was thrown while trying to create a new server transaction");
            }
            SipProviderTest.assertNotNull("A null ServerTransaction was returned by SipProvider.getNewServerTransaction().", tran);
            String tranBranch = tran.getBranchId();
            String reqBranch = ((ViaHeader)invite.getHeader("Via")).getBranch();
            SipProviderTest.assertEquals("The newly created transaction did not have the same branch id as the request that created it!", tranBranch, reqBranch);
            SipProviderTest.assertNotNull("The newly created transaction returned a null Dialog. Please check the docs on Transaction.getDialog()", tran.getDialog());
            SipProviderTest.assertNotNull("The transaction's getRequest() method returned a null Request ", tran.getRequest());
            SipProviderTest.assertEquals("The transaction's getRequest() method returned a Request that did not match the one that we used to create it!", tran.getRequest(), receivedRequestEvent.getRequest());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            SipProviderTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        SipProviderTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public static Test suite() {
        return new TestSuite(SipProviderTest.class);
    }
}

