/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.msgflow.InviteClientTransactionsStateMachineTest;
import test.tck.msgflow.MessageFlowHarness;

public class TransactionTimeoutEventTest
extends MessageFlowHarness {
    private static Logger logger = Logger.getLogger(InviteClientTransactionsStateMachineTest.class);

    public TransactionTimeoutEventTest(String name) {
        super(name, false);
    }

    public void testClientTransactionTimeout() {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                tran = this.tiSipProvider.getNewClientTransaction(invite);
                tran.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            TransactionTimeoutEventTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            TransactionTimeoutEventTest.assertNotNull("RequestEvent", inviteReceivedEvent);
            try {
                this.eventCollector.collectTimeoutEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            TransactionTimeoutEventTest.waitForTimeout();
            TimeoutEvent timeoutEvent = this.eventCollector.extractCollectedTimeoutEvent();
            TransactionTimeoutEventTest.assertNotNull("Timeout event", timeoutEvent);
            TransactionTimeoutEventTest.assertTrue("Timeout event type ", timeoutEvent.getTimeout().equals(Timeout.TRANSACTION));
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected exception ", (Throwable)ex);
            ex.printStackTrace();
            TransactionTimeoutEventTest.fail("unexpected exception");
        }
    }

    public void testServerTransactionForTimeout() {
        try {
            Request invite = this.createRiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                tran = this.riSipProvider.getNewClientTransaction(invite);
                tran.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            TransactionTimeoutEventTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            TransactionTimeoutEventTest.assertNotNull("RequestEvent not seen at TI", inviteReceivedEvent);
            TransactionTimeoutEventTest.assertTrue("Server Transaction MUST be null", inviteReceivedEvent.getServerTransaction() == null);
            ServerTransaction st = this.tiSipProvider.getNewServerTransaction(inviteReceivedEvent.getRequest());
            Response response = tiMessageFactory.createResponse(200, inviteReceivedEvent.getRequest());
            ToHeader toHeader = (ToHeader)response.getHeader("To");
            toHeader.setTag("123456");
            ContactHeader contact = super.createTiContact();
            response.setHeader((Header)contact);
            st.sendResponse(response);
            this.eventCollector.collectTimeoutEvent(this.tiSipProvider);
            TransactionTimeoutEventTest.waitForTimeout();
            TimeoutEvent timeoutEvent = this.eventCollector.extractCollectedTimeoutEvent();
            TransactionTimeoutEventTest.assertNull("Timeout event", timeoutEvent);
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected exception ", (Throwable)ex);
            ex.printStackTrace();
            TransactionTimeoutEventTest.fail("unexpected exception");
        }
    }

    public void testServerTransactionForRetransmissionAlerts() {
        try {
            Request invite = this.createRiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            this.tiSipProvider.setAutomaticDialogSupportEnabled(false);
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                tran = this.riSipProvider.getNewClientTransaction(invite);
                tran.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            TransactionTimeoutEventTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            TransactionTimeoutEventTest.assertNotNull("RequestEvent not seen at TI", inviteReceivedEvent);
            TransactionTimeoutEventTest.assertTrue("Server Transaction MUST be null", inviteReceivedEvent.getServerTransaction() == null);
            ServerTransaction st = this.tiSipProvider.getNewServerTransaction(inviteReceivedEvent.getRequest());
            Response response = tiMessageFactory.createResponse(200, inviteReceivedEvent.getRequest());
            ToHeader toHeader = (ToHeader)response.getHeader("To");
            toHeader.setTag("1234567");
            ContactHeader contact = super.createTiContact();
            response.setHeader((Header)contact);
            st.enableRetransmissionAlerts();
            st.sendResponse(response);
            this.eventCollector.collectTimeoutEvent(this.tiSipProvider);
            TransactionTimeoutEventTest.waitForTimeout();
            TimeoutEvent timeoutEvent = this.eventCollector.extractCollectedTimeoutEvent();
            TransactionTimeoutEventTest.assertNotNull("Timeout event not found ", timeoutEvent);
            TransactionTimeoutEventTest.assertTrue("Timeout event type must be retransmit ", timeoutEvent.getTimeout().equals(Timeout.RETRANSMIT));
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected exception ", (Throwable)ex);
            ex.printStackTrace();
            TransactionTimeoutEventTest.fail("unexpected exception");
        }
    }
}

