/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.address.AddressFactory;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import test.tck.msgflow.callflows.NonSipUriRouter;

public class ProtocolObjects {
    public final AddressFactory addressFactory;
    public final MessageFactory messageFactory;
    public final HeaderFactory headerFactory;
    public final SipStack sipStack;
    public int logLevel = 32;
    String logFileDirectory = "logs/";
    public final String transport;
    private boolean isStarted;
    public boolean autoDialog;

    public ProtocolObjects(String stackname, String pathname, String transport, boolean autoDialog, boolean isBackToBackUserAgent) {
        this.autoDialog = autoDialog;
        this.transport = transport;
        SipFactory sipFactory = SipFactory.getInstance();
        sipFactory.resetFactory();
        sipFactory.setPathName(pathname);
        Properties properties = new Properties();
        properties.setProperty("javax.sip.STACK_NAME", stackname);
        properties.setProperty("gov.nist.javax.sip.DEBUG_LOG", this.logFileDirectory + stackname + "debuglog.txt");
        properties.setProperty("gov.nist.javax.sip.SERVER_LOG", this.logFileDirectory + stackname + "log.txt");
        properties.setProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT", autoDialog ? "on" : "off");
        properties.setProperty("javax.sip.FORKABLE_EVENTS", "foo");
        properties.setProperty("javax.sip.ROUTER_PATH", NonSipUriRouter.class.getName());
        properties.setProperty("javax.sip.USE_ROUTER_FOR_ALL_URIS", "false");
        properties.setProperty("gov.nist.javax.sip.THREAD_POOL_SIZE", "1");
        properties.setProperty("gov.nist.javax.sip.IS_BACK_TO_BACK_USER_AGENT", Boolean.toString(isBackToBackUserAgent));
        properties.setProperty("gov.nist.javax.sip.DELIVER_RETRANSMITTED_ACK_TO_LISTENER", "true");
        properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", new Integer(this.logLevel).toString());
        try {
            this.sipStack = sipFactory.createSipStack(properties);
            NonSipUriRouter router = (NonSipUriRouter)this.sipStack.getRouter();
            router.setMyPort(5080);
            System.out.println("createSipStack " + this.sipStack);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            throw new RuntimeException("Stack failed to initialize");
        }
        try {
            this.headerFactory = sipFactory.createHeaderFactory();
            this.addressFactory = sipFactory.createAddressFactory();
            this.messageFactory = sipFactory.createMessageFactory();
        }
        catch (SipException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public synchronized void destroy() {
        HashSet<SipProvider> hashSet = new HashSet<SipProvider>();
        Iterator it = this.sipStack.getSipProviders();
        while (it.hasNext()) {
            SipProvider sipProvider = (SipProvider)it.next();
            hashSet.add(sipProvider);
        }
        for (SipProvider sipProvider : hashSet) {
            for (int j = 0; j < 5; ++j) {
                try {
                    this.sipStack.deleteSipProvider(sipProvider);
                    continue;
                }
                catch (ObjectInUseException ex) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        this.sipStack.stop();
    }

    public void start() throws Exception {
        if (this.isStarted) {
            return;
        }
        this.sipStack.start();
        this.isStarted = true;
    }
}

