/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import test.tck.TckInternalError;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;

public abstract class ScenarioHarness
extends TestHarness {
    private HashSet<ProtocolObjects> tiProtocolObjects = new HashSet();
    private HashSet<ProtocolObjects> riProtocolObjects = new HashSet();
    protected String transport;
    protected Hashtable providerTable = new Hashtable();
    protected boolean testedImplFlag;

    public void setUp() throws Exception {
        if (this.testedImplFlag) {
            this.tiProtocolObjects.add(new ProtocolObjects("ti" + super.getName(), "gov.nist", this.transport, true, false));
            this.addRiProtocolObjects(new ProtocolObjects("ri" + super.getName(), super.getImplementationPath(), this.transport, true, false));
        } else {
            this.tiProtocolObjects.add(new ProtocolObjects("ti" + super.getName(), this.getImplementationPath(), this.transport, true, false));
            this.addRiProtocolObjects(new ProtocolObjects("ri" + super.getName(), "gov.nist", this.transport, true, false));
        }
    }

    public void setUp(int nri, int nti) throws Exception {
        if (this.testedImplFlag) {
            int i;
            for (i = 0; i < nti; ++i) {
                this.tiProtocolObjects.add(new ProtocolObjects("ti" + super.getName() + i, "gov.nist", this.transport, true, false));
            }
            for (i = 0; i < nri; ++i) {
                this.addRiProtocolObjects(new ProtocolObjects("ri" + super.getName() + i, super.getImplementationPath(), this.transport, true, false));
            }
        } else {
            int i;
            for (i = 0; i < nti; ++i) {
                this.tiProtocolObjects.add(new ProtocolObjects("ti" + super.getName() + i, this.getImplementationPath(), this.transport, true, false));
            }
            for (i = 0; i < nri; ++i) {
                this.addRiProtocolObjects(new ProtocolObjects("ri" + super.getName() + i, "gov.nist", this.transport, true, false));
            }
        }
    }

    public void setUp(boolean riAutoDialog) throws Exception {
        if (this.testedImplFlag) {
            this.tiProtocolObjects.add(new ProtocolObjects("ti" + super.getName(), "gov.nist", this.transport, true, false));
            this.addRiProtocolObjects(new ProtocolObjects("ri" + super.getName(), super.getImplementationPath(), this.transport, riAutoDialog, false));
        } else {
            this.tiProtocolObjects.add(new ProtocolObjects("ti" + super.getName(), this.getImplementationPath(), this.transport, true, false));
            this.addRiProtocolObjects(new ProtocolObjects("ri" + super.getName(), "gov.nist", this.transport, riAutoDialog, false));
        }
    }

    public void setUp(boolean riAutoDialog, int nri, int nti) {
        if (this.testedImplFlag) {
            int i;
            for (i = 0; i < nti; ++i) {
                this.tiProtocolObjects.add(new ProtocolObjects("ti" + super.getName() + i, "gov.nist", this.transport, true, false));
            }
            for (i = 0; i < nri; ++i) {
                this.addRiProtocolObjects(new ProtocolObjects("ri" + super.getName(), super.getImplementationPath(), this.transport, riAutoDialog, false));
            }
        } else {
            int i;
            for (i = 0; i < nti; ++i) {
                this.tiProtocolObjects.add(new ProtocolObjects("ti" + super.getName() + i, this.getImplementationPath(), this.transport, true, false));
            }
            for (i = 0; i < nri; ++i) {
                this.addRiProtocolObjects(new ProtocolObjects("ri" + super.getName(), "gov.nist", this.transport, riAutoDialog, false));
            }
        }
    }

    private SipListener getSipListener(EventObject sipEvent) {
        SipProvider source = (SipProvider)sipEvent.getSource();
        SipListener listener = (SipListener)this.providerTable.get(source);
        if (listener == null) {
            throw new TckInternalError("Unexpected null listener");
        }
        return listener;
    }

    public void processRequest(RequestEvent requestEvent) {
        this.getSipListener((EventObject)requestEvent).processRequest(requestEvent);
    }

    public void processResponse(ResponseEvent responseEvent) {
        this.getSipListener((EventObject)responseEvent).processResponse(responseEvent);
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        this.getSipListener((EventObject)timeoutEvent).processTimeout(timeoutEvent);
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        System.out.println("IOException ");
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        this.getSipListener((EventObject)transactionTerminatedEvent).processTransactionTerminated(transactionTerminatedEvent);
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        this.getSipListener((EventObject)dialogTerminatedEvent).processDialogTerminated(dialogTerminatedEvent);
    }

    protected ScenarioHarness(String name, boolean autoDialog) {
        super(name, autoDialog);
    }

    protected ScenarioHarness(String name, boolean autoDialog, int nri, int nti) {
        super(name, autoDialog);
    }

    protected void addRiProtocolObjects(ProtocolObjects riProtocolObjects) {
        this.riProtocolObjects.add(riProtocolObjects);
    }

    protected ProtocolObjects getRiProtocolObjects() {
        return this.riProtocolObjects.iterator().next();
    }

    protected void addTiProtocolObjects(ProtocolObjects tiProtocolObjects) {
        this.tiProtocolObjects.add(tiProtocolObjects);
    }

    protected ProtocolObjects getTiProtocolObjects() {
        return this.tiProtocolObjects.iterator().next();
    }

    public ProtocolObjects getTiProtocolObjects(int index) {
        return (ProtocolObjects)this.tiProtocolObjects.toArray()[index];
    }

    public ProtocolObjects getRiProtocolObjects(int index) {
        return (ProtocolObjects)this.riProtocolObjects.toArray()[index];
    }

    public void tearDown() throws Exception {
        for (ProtocolObjects protocolObjects : this.tiProtocolObjects) {
            protocolObjects.destroy();
        }
        for (ProtocolObjects protocolObjects : this.riProtocolObjects) {
            protocolObjects.destroy();
        }
    }

    public void start() throws Exception {
        for (ProtocolObjects protocolObjects : this.tiProtocolObjects) {
            protocolObjects.start();
        }
        for (ProtocolObjects protocolObjects : this.riProtocolObjects) {
            protocolObjects.start();
        }
    }
}

