/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.forkedinvite;

import java.util.Hashtable;
import java.util.Iterator;
import javax.sip.ClientTransaction;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.Header;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;

public class Proxy
extends TestHarness
implements SipListener {
    private SipProvider inviteServerTxProvider;
    private Hashtable clientTxTable = new Hashtable();
    private static String host = "127.0.0.1";
    private int port = 5070;
    private SipProvider sipProvider;
    private static String unexpectedException = "Unexpected exception";
    private static Logger logger = Logger.getLogger(Proxy.class);
    private ProtocolObjects protocolObjects;

    public synchronized void processRequest(RequestEvent requestEvent) {
        try {
            SipProvider sipProvider;
            Request request = requestEvent.getRequest();
            this.inviteServerTxProvider = sipProvider = (SipProvider)requestEvent.getSource();
            if (request.getMethod().equals("INVITE")) {
                ListeningPoint lp = sipProvider.getListeningPoint(this.protocolObjects.transport);
                String host = lp.getIPAddress();
                int port = lp.getPort();
                ServerTransaction st = null;
                if (requestEvent.getServerTransaction() == null) {
                    st = sipProvider.getNewServerTransaction(request);
                    Request newRequest = (Request)request.clone();
                    ((SipURI)newRequest.getRequestURI()).removePort();
                    SipURI sipUri = this.protocolObjects.addressFactory.createSipURI("UA1", "127.0.0.1");
                    sipUri.setPort(5080);
                    sipUri.setLrParam();
                    Address address = this.protocolObjects.addressFactory.createAddress("client1", (URI)sipUri);
                    RouteHeader rheader = this.protocolObjects.headerFactory.createRouteHeader(address);
                    newRequest.setHeader((Header)rheader);
                    ViaHeader viaHeader = this.protocolObjects.headerFactory.createViaHeader(host, port, this.protocolObjects.transport, null);
                    newRequest.addFirst((Header)viaHeader);
                    ClientTransaction ct1 = sipProvider.getNewClientTransaction(newRequest);
                    sipUri = this.protocolObjects.addressFactory.createSipURI("proxy", "127.0.0.1");
                    address = this.protocolObjects.addressFactory.createAddress("proxy", (URI)sipUri);
                    sipUri.setPort(5070);
                    sipUri.setLrParam();
                    RecordRouteHeader recordRoute = this.protocolObjects.headerFactory.createRecordRouteHeader(address);
                    newRequest.addHeader((Header)recordRoute);
                    ct1.setApplicationData((Object)st);
                    this.clientTxTable.put(new Integer(5080), ct1);
                    newRequest = (Request)request.clone();
                    ((SipURI)newRequest.getRequestURI()).removePort();
                    sipUri = this.protocolObjects.addressFactory.createSipURI("UA2", "127.0.0.1");
                    sipUri.setLrParam();
                    sipUri.setPort(5090);
                    address = this.protocolObjects.addressFactory.createAddress("client2", (URI)sipUri);
                    rheader = this.protocolObjects.headerFactory.createRouteHeader(address);
                    newRequest.setHeader((Header)rheader);
                    viaHeader = this.protocolObjects.headerFactory.createViaHeader(host, port, this.protocolObjects.transport, null);
                    newRequest.addFirst((Header)viaHeader);
                    sipUri = this.protocolObjects.addressFactory.createSipURI("proxy", "127.0.0.1");
                    sipUri.setPort(5070);
                    sipUri.setLrParam();
                    sipUri.setTransportParam(this.protocolObjects.transport);
                    address = this.protocolObjects.addressFactory.createAddress("proxy", (URI)sipUri);
                    recordRoute = this.protocolObjects.headerFactory.createRecordRouteHeader(address);
                    newRequest.addHeader((Header)recordRoute);
                    ClientTransaction ct2 = sipProvider.getNewClientTransaction(newRequest);
                    ct2.setApplicationData((Object)st);
                    this.clientTxTable.put(new Integer(5090), ct2);
                    ct2.sendRequest();
                    ct1.sendRequest();
                }
            } else {
                logger.info((Object)("proxy: Got a request " + request));
                Request newRequest = (Request)request.clone();
                newRequest.removeFirst("Route");
                sipProvider.sendRequest(newRequest);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        try {
            Response response = responseEvent.getResponse();
            CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
            logger.info((Object)("ClientTxID = " + responseEvent.getClientTransaction() + " client tx id " + ((ViaHeader)response.getHeader("Via")).getBranch() + " CSeq header = " + response.getHeader("CSeq") + " status code = " + response.getStatusCode()));
            if (response.getStatusCode() == 100) {
                return;
            }
            if (cseq.getMethod().equals("INVITE")) {
                ClientTransaction ct = responseEvent.getClientTransaction();
                if (ct != null) {
                    ServerTransaction st = (ServerTransaction)ct.getApplicationData();
                    Response newResponse = (Response)response.clone();
                    newResponse.removeFirst("Via");
                    st.sendResponse(newResponse);
                } else {
                    Response newResponse = (Response)response.clone();
                    newResponse.removeFirst("Via");
                    this.inviteServerTxProvider.sendResponse(newResponse);
                }
            } else {
                logger.info((Object)("Got a non-invite response " + response));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Proxy.fail("unexpected exception");
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        logger.error((Object)"Timeout occured");
        Proxy.fail("unexpected event");
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.info((Object)"IOException occured");
        Proxy.fail("unexpected exception io exception");
    }

    public SipProvider createSipProvider() {
        try {
            ListeningPoint listeningPoint = this.protocolObjects.sipStack.createListeningPoint(host, this.port, this.protocolObjects.transport);
            this.sipProvider = this.protocolObjects.sipStack.createSipProvider(listeningPoint);
            return this.sipProvider;
        }
        catch (Exception ex) {
            logger.error((Object)unexpectedException, (Throwable)ex);
            Proxy.fail(unexpectedException);
            return null;
        }
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        logger.info((Object)"Transaction terminated event occured -- cleaning up");
        if (!transactionTerminatedEvent.isServerTransaction()) {
            ClientTransaction ct = transactionTerminatedEvent.getClientTransaction();
            Iterator it = this.clientTxTable.values().iterator();
            while (it.hasNext()) {
                if (!it.next().equals(ct)) continue;
                it.remove();
            }
        } else {
            logger.info((Object)"Server tx terminated! ");
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        Proxy.fail("unexpected event");
    }

    public Proxy(int myPort, ProtocolObjects protocolObjects) {
        this.port = myPort;
        this.protocolObjects = protocolObjects;
    }
}

