/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.forkedinvite;

import java.util.ArrayList;
import java.util.HashSet;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;

public class Shootist
implements SipListener {
    private ContactHeader contactHeader;
    private ClientTransaction inviteTid;
    private SipProvider sipProvider;
    private String host = "127.0.0.1";
    private int port;
    private String peerHost = "127.0.0.1";
    private int peerPort;
    private ListeningPoint listeningPoint;
    private static String unexpectedException = "Unexpected exception ";
    private static Logger logger = Logger.getLogger(Shootist.class);
    private ProtocolObjects protocolObjects;
    private Dialog originalDialog;
    private HashSet forkedDialogs = new HashSet();
    private Dialog ackedDialog;

    private Shootist() {
    }

    public Shootist(int myPort, int proxyPort, ProtocolObjects protocolObjects) {
        this();
        this.protocolObjects = protocolObjects;
        this.port = myPort;
        this.peerPort = proxyPort;
        protocolObjects.logLevel = 32;
    }

    public void processRequest(RequestEvent requestReceivedEvent) {
        Request request = requestReceivedEvent.getRequest();
        ServerTransaction serverTransactionId = requestReceivedEvent.getServerTransaction();
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + this.protocolObjects.sipStack.getStackName() + " with server transaction id " + serverTransactionId));
        if (request.getMethod().equals("BYE")) {
            this.processBye(request, serverTransactionId);
        } else {
            TestHarness.fail("Unexpected request ! : " + request);
        }
    }

    public void processBye(Request request, ServerTransaction serverTransactionId) {
        try {
            logger.info((Object)"shootist:  got a bye .");
            if (serverTransactionId == null) {
                logger.info((Object)"shootist:  null TID.");
                return;
            }
            Dialog dialog = serverTransactionId.getDialog();
            logger.info((Object)("Dialog State = " + dialog.getState()));
            Response response = this.protocolObjects.messageFactory.createResponse(200, request);
            serverTransactionId.sendResponse(response);
            logger.info((Object)"shootist:  Sending OK.");
            logger.info((Object)("Dialog State = " + dialog.getState()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void processResponse(ResponseEvent responseReceivedEvent) {
        logger.info((Object)"Got a response");
        Response response = responseReceivedEvent.getResponse();
        ClientTransaction tid = responseReceivedEvent.getClientTransaction();
        CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
        logger.info((Object)("Response received : Status Code = " + response.getStatusCode() + " " + cseq));
        logger.info((Object)("Response = " + response + " class=" + response.getClass()));
        Dialog dialog = responseReceivedEvent.getDialog();
        TestHarness.assertNotNull((Object)dialog);
        if (tid != null) {
            logger.info((Object)("transaction state is " + tid.getState()));
        } else {
            logger.info((Object)("transaction = " + tid));
        }
        logger.info((Object)("Dialog = " + dialog));
        logger.info((Object)("SHOOTIST: Dialog state is " + dialog.getState()));
        try {
            if (response.getStatusCode() == 200) {
                if (cseq.getMethod().equals("INVITE")) {
                    Request ackRequest = dialog.createAck(cseq.getSeqNumber());
                    TestHarness.assertNotNull((Object)ackRequest.getHeader("Max-Forwards"));
                    this.forkedDialogs.add(dialog);
                    logger.info((Object)"Sending ACK");
                    dialog.sendAck(ackRequest);
                    if (dialog.getState() == DialogState.TERMINATED) {
                        return;
                    }
                    if (this.forkedDialogs.size() == 2) {
                        TestHarness.assertTrue("Dialog state should be CONFIRMED", dialog.getState() == DialogState.CONFIRMED);
                        this.ackedDialog = dialog;
                        return;
                    } else {
                        SipProvider sipProvider = (SipProvider)responseReceivedEvent.getSource();
                        Request byeRequest = dialog.createRequest("BYE");
                        ClientTransaction ct = sipProvider.getNewClientTransaction(byeRequest);
                        dialog.sendRequest(ct);
                    }
                    return;
                } else {
                    logger.info((Object)("Response method = " + cseq.getMethod()));
                }
                return;
            }
            if (response.getStatusCode() != 180) return;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public SipProvider createSipProvider() {
        try {
            this.listeningPoint = this.protocolObjects.sipStack.createListeningPoint(this.host, this.port, this.protocolObjects.transport);
            logger.info((Object)("listening point = " + this.host + " port = " + this.port));
            logger.info((Object)("listening point = " + this.listeningPoint));
            this.sipProvider = this.protocolObjects.sipStack.createSipProvider(this.listeningPoint);
            return this.sipProvider;
        }
        catch (Exception ex) {
            logger.error((Object)unexpectedException, (Throwable)ex);
            TestHarness.fail(unexpectedException);
            return null;
        }
    }

    public void checkState() {
        TestHarness.assertEquals((String)"Should see two distinct dialogs", (int)2, (int)this.forkedDialogs.size());
        TestHarness.assertTrue("Should see the original (default) dialog in the forked set", this.forkedDialogs.contains(this.originalDialog));
        this.forkedDialogs.clear();
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        logger.info((Object)"Transaction Time out");
    }

    public void sendInvite() {
        try {
            String fromName = "BigGuy";
            String fromSipAddress = "here.com";
            String fromDisplayName = "The Master Blaster";
            String toSipAddress = "there.com";
            String toUser = "LittleGuy";
            String toDisplayName = "The Little Blister";
            SipURI fromAddress = this.protocolObjects.addressFactory.createSipURI(fromName, fromSipAddress);
            Address fromNameAddress = this.protocolObjects.addressFactory.createAddress((URI)fromAddress);
            fromNameAddress.setDisplayName(fromDisplayName);
            FromHeader fromHeader = this.protocolObjects.headerFactory.createFromHeader(fromNameAddress, "12345");
            SipURI toAddress = this.protocolObjects.addressFactory.createSipURI(toUser, toSipAddress);
            Address toNameAddress = this.protocolObjects.addressFactory.createAddress((URI)toAddress);
            toNameAddress.setDisplayName(toDisplayName);
            ToHeader toHeader = this.protocolObjects.headerFactory.createToHeader(toNameAddress, null);
            String peerHostPort = this.peerHost + ":" + this.peerPort;
            SipURI requestURI = this.protocolObjects.addressFactory.createSipURI(toUser, peerHostPort);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            ViaHeader viaHeader = this.protocolObjects.headerFactory.createViaHeader(this.host, this.sipProvider.getListeningPoint(this.protocolObjects.transport).getPort(), this.protocolObjects.transport, null);
            viaHeaders.add(viaHeader);
            SipURI sipuri = this.protocolObjects.addressFactory.createSipURI(null, this.host);
            sipuri.setPort(this.peerPort);
            sipuri.setLrParam();
            RouteHeader routeHeader = this.protocolObjects.headerFactory.createRouteHeader(this.protocolObjects.addressFactory.createAddress((URI)sipuri));
            ContentTypeHeader contentTypeHeader = this.protocolObjects.headerFactory.createContentTypeHeader("application", "sdp");
            CallIdHeader callIdHeader = this.sipProvider.getNewCallId();
            callIdHeader = this.protocolObjects.headerFactory.createCallIdHeader(callIdHeader.getCallId());
            CSeqHeader cSeqHeader = this.protocolObjects.headerFactory.createCSeqHeader(1L, "INVITE");
            MaxForwardsHeader maxForwards = this.protocolObjects.headerFactory.createMaxForwardsHeader(70);
            Request request = this.protocolObjects.messageFactory.createRequest((URI)requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
            SipURI contactUrl = this.protocolObjects.addressFactory.createSipURI(fromName, this.host);
            contactUrl.setPort(this.listeningPoint.getPort());
            SipURI contactURI = this.protocolObjects.addressFactory.createSipURI(fromName, this.host);
            contactURI.setPort(this.sipProvider.getListeningPoint(this.protocolObjects.transport).getPort());
            contactURI.setTransportParam(this.protocolObjects.transport);
            Address contactAddress = this.protocolObjects.addressFactory.createAddress((URI)contactURI);
            contactAddress.setDisplayName(fromName);
            this.contactHeader = this.protocolObjects.headerFactory.createContactHeader(contactAddress);
            request.addHeader((Header)this.contactHeader);
            request.setHeader((Header)routeHeader);
            Header extensionHeader = this.protocolObjects.headerFactory.createHeader("My-Header", "my header value");
            request.addHeader(extensionHeader);
            String sdpData = "v=0\r\no=4855 13760799956958020 13760799956958020 IN IP4  129.6.55.78\r\ns=mysession session\r\np=+46 8 52018010\r\nc=IN IP4  129.6.55.78\r\nt=0 0\r\nm=audio 6022 RTP/AVP 0 4 18\r\na=rtpmap:0 PCMU/8000\r\na=rtpmap:4 G723/8000\r\na=rtpmap:18 G729A/8000\r\na=ptime:20\r\n";
            byte[] contents = sdpData.getBytes();
            request.setContent((Object)contents, contentTypeHeader);
            extensionHeader = this.protocolObjects.headerFactory.createHeader("My-Other-Header", "my new header value ");
            request.addHeader(extensionHeader);
            Header callInfoHeader = this.protocolObjects.headerFactory.createHeader("Call-Info", "<http://www.antd.nist.gov>");
            request.addHeader(callInfoHeader);
            this.inviteTid = this.sipProvider.getNewClientTransaction(request);
            Dialog dialog = this.inviteTid.getDialog();
            TestHarness.assertTrue("Initial dialog state should be null", dialog.getState() == null);
            this.inviteTid.sendRequest();
            this.originalDialog = dialog;
        }
        catch (Exception ex) {
            logger.error((Object)unexpectedException, (Throwable)ex);
            TestHarness.fail(unexpectedException);
        }
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.info((Object)("IOException happened for " + exceptionEvent.getHost() + " port = " + exceptionEvent.getPort()));
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        logger.info((Object)"Transaction terminated event recieved");
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        logger.info((Object)"dialogTerminatedEvent");
    }
}

