/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.forkedinvite;

import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;

public class Shootme
implements SipListener {
    private static final String myAddress = "127.0.0.1";
    private Hashtable serverTxTable = new Hashtable();
    private SipProvider sipProvider;
    private int myPort;
    private static String unexpectedException = "Unexpected exception ";
    private static Logger logger = Logger.getLogger(Shootme.class);
    private ProtocolObjects protocolObjects;
    private boolean inviteSeen;
    private boolean byeSeen;
    private boolean ackSeen;
    private boolean actAsNonRFC3261UAS;

    public void setNonRFC3261(boolean b) {
        this.actAsNonRFC3261UAS = b;
    }

    public void processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        ServerTransaction serverTransactionId = requestEvent.getServerTransaction();
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + this.protocolObjects.sipStack.getStackName() + " with server transaction id " + serverTransactionId));
        if (request.getMethod().equals("INVITE")) {
            this.processInvite(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("ACK")) {
            this.processAck(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("BYE")) {
            this.processBye(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("CANCEL")) {
            this.processCancel(requestEvent, serverTransactionId);
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
    }

    public void processAck(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        logger.info((Object)"shootme: got an ACK! ");
        logger.info((Object)("Dialog = " + requestEvent.getDialog()));
        if (requestEvent.getDialog() != null) {
            logger.info((Object)("Dialog State = " + requestEvent.getDialog().getState()));
        }
        this.ackSeen = true;
    }

    public void processInvite(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        try {
            String toTag;
            logger.info((Object)"shootme: got an Invite sending Trying");
            ServerTransaction st = requestEvent.getServerTransaction();
            if (st == null) {
                logger.info((Object)"null server tx -- getting a new one");
                st = sipProvider.getNewServerTransaction(request);
            }
            logger.info((Object)("getNewServerTransaction : " + st));
            String txId = ((ViaHeader)request.getHeader("Via")).getBranch();
            this.serverTxTable.put(txId, st);
            Response response = this.protocolObjects.messageFactory.createResponse(100, request);
            ListeningPoint lp = sipProvider.getListeningPoint(this.protocolObjects.transport);
            int myPort = lp.getPort();
            Address address = this.protocolObjects.addressFactory.createAddress("Shootme <sip:127.0.0.1:" + myPort + ">");
            int timeToSleep = (int)(Math.random() * 1000.0);
            st.sendResponse(response);
            Response ringingResponse = this.protocolObjects.messageFactory.createResponse(180, request);
            ContactHeader contactHeader = this.protocolObjects.headerFactory.createContactHeader(address);
            response.addHeader((Header)contactHeader);
            ToHeader toHeader = (ToHeader)ringingResponse.getHeader("To");
            String string = toTag = this.actAsNonRFC3261UAS ? null : new Integer((int)(Math.random() * 10000.0)).toString();
            if (!this.actAsNonRFC3261UAS) {
                toHeader.setTag(toTag);
            }
            ringingResponse.addHeader((Header)contactHeader);
            st.sendResponse(ringingResponse);
            Dialog dialog = st.getDialog();
            dialog.setApplicationData((Object)st);
            this.inviteSeen = true;
            new Timer().schedule((TimerTask)new MyTimerTask(requestEvent, st), timeToSleep);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    private void sendInviteOK(RequestEvent requestEvent, ServerTransaction inviteTid) {
        try {
            logger.info((Object)("sendInviteOK: " + inviteTid));
            if (inviteTid.getState() != TransactionState.COMPLETED) {
                logger.info((Object)("shootme: Dialog state before OK: " + inviteTid.getDialog().getState()));
                SipProvider sipProvider = (SipProvider)requestEvent.getSource();
                Request request = requestEvent.getRequest();
                Response okResponse = this.protocolObjects.messageFactory.createResponse(200, request);
                ListeningPoint lp = sipProvider.getListeningPoint(this.protocolObjects.transport);
                int myPort = lp.getPort();
                Address address = this.protocolObjects.addressFactory.createAddress("Shootme <sip:127.0.0.1:" + myPort + ">");
                ContactHeader contactHeader = this.protocolObjects.headerFactory.createContactHeader(address);
                okResponse.addHeader((Header)contactHeader);
                inviteTid.sendResponse(okResponse);
            } else {
                logger.info((Object)("semdInviteOK: inviteTid = " + inviteTid + " state = " + inviteTid.getState()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void processBye(RequestEvent requestEvent, ServerTransaction serverTransactionId) {
        Request request = requestEvent.getRequest();
        try {
            logger.info((Object)"shootme:  got a bye sending OK.");
            logger.info((Object)("shootme:  dialog = " + requestEvent.getDialog()));
            logger.info((Object)("shootme:  dialogState = " + requestEvent.getDialog().getState()));
            Response response = this.protocolObjects.messageFactory.createResponse(200, request);
            if (serverTransactionId != null) {
                serverTransactionId.sendResponse(response);
            }
            logger.info((Object)("shootme:  dialogState = " + requestEvent.getDialog().getState()));
            this.byeSeen = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void processCancel(RequestEvent requestEvent, ServerTransaction serverTransactionId) {
        Request request = requestEvent.getRequest();
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        try {
            logger.info((Object)"shootme:  got a cancel. ");
            if (serverTransactionId == null) {
                serverTransactionId = sipProvider.getNewServerTransaction(request);
            }
            Response response = this.protocolObjects.messageFactory.createResponse(200, request);
            serverTransactionId.sendResponse(response);
            String serverTxId = ((ViaHeader)response.getHeader("Via")).getBranch();
            ServerTransaction serverTx = (ServerTransaction)this.serverTxTable.get(serverTxId);
            if (serverTx != null && (serverTx.getState().equals((Object)TransactionState.TRYING) || serverTx.getState().equals((Object)TransactionState.PROCEEDING))) {
                Request originalRequest = serverTx.getRequest();
                Response resp = this.protocolObjects.messageFactory.createResponse(487, originalRequest);
                serverTx.sendResponse(resp);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        Object transaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        logger.info((Object)("state = " + transaction.getState()));
        logger.info((Object)("dialog = " + transaction.getDialog()));
        logger.info((Object)("dialogState = " + transaction.getDialog().getState()));
        logger.info((Object)"Transaction Time out");
    }

    public SipProvider createProvider() {
        try {
            ListeningPoint lp = this.protocolObjects.sipStack.createListeningPoint(myAddress, this.myPort, this.protocolObjects.transport);
            this.sipProvider = this.protocolObjects.sipStack.createSipProvider(lp);
            logger.info((Object)("provider " + this.sipProvider));
            logger.info((Object)("sipStack = " + this.protocolObjects.sipStack));
            return this.sipProvider;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            TestHarness.fail(unexpectedException);
            return null;
        }
    }

    public Shootme(int myPort, ProtocolObjects protocolObjects) {
        this.myPort = myPort;
        this.protocolObjects = protocolObjects;
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.info((Object)"IOException");
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        logger.info((Object)"Transaction terminated event recieved");
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        logger.info((Object)"Dialog terminated event recieved");
    }

    public void checkState() {
        TestHarness.assertTrue("Should see invite", this.inviteSeen);
        TestHarness.assertTrue("Should see either an ACK or a BYE, or both", this.byeSeen || this.ackSeen);
    }

    class MyTimerTask
    extends TimerTask {
        RequestEvent requestEvent;
        ServerTransaction serverTx;

        public MyTimerTask(RequestEvent requestEvent, ServerTransaction tx) {
            logger.info((Object)"MyTimerTask ");
            this.requestEvent = requestEvent;
            this.serverTx = tx;
        }

        public void run() {
            Shootme.this.sendInviteOK(this.requestEvent, this.serverTx);
        }
    }
}

