/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.prack;

import java.util.ArrayList;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RequireHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;

public class Shootist
implements SipListener {
    private static SipProvider sipProvider;
    private static AddressFactory addressFactory;
    private static MessageFactory messageFactory;
    private static HeaderFactory headerFactory;
    private static SipStack sipStack;
    private ContactHeader contactHeader;
    private ClientTransaction inviteTid;
    private Dialog dialog;
    private String transport;
    private boolean prackTriggerReceived;
    private boolean prackConfirmed;
    public static final int myPort = 5070;
    private static Logger logger;
    private String toUser = "LittleGuy";

    public Shootist(ProtocolObjects protObjects) {
        addressFactory = protObjects.addressFactory;
        messageFactory = protObjects.messageFactory;
        headerFactory = protObjects.headerFactory;
        sipStack = protObjects.sipStack;
        this.transport = protObjects.transport;
    }

    public SipProvider createProvider() throws Exception {
        ListeningPoint lp = sipStack.createListeningPoint("127.0.0.1", 5070, this.transport);
        sipProvider = sipStack.createSipProvider(lp);
        logger.info((Object)(this.transport + " SIP provider " + sipProvider));
        return sipProvider;
    }

    public void processRequest(RequestEvent requestReceivedEvent) {
        Request request = requestReceivedEvent.getRequest();
        ServerTransaction serverTransactionId = requestReceivedEvent.getServerTransaction();
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + sipStack.getStackName() + " with server transaction id " + serverTransactionId));
        if (request.getMethod().equals("BYE")) {
            this.processBye(request, serverTransactionId);
        }
    }

    public void processBye(Request request, ServerTransaction serverTransactionId) {
        try {
            logger.info((Object)"shootist:  got a bye .");
            if (serverTransactionId == null) {
                logger.info((Object)"shootist:  null TID.");
                return;
            }
            Dialog dialog = serverTransactionId.getDialog();
            logger.info((Object)("Dialog State = " + dialog.getState()));
            Response response = messageFactory.createResponse(200, request);
            serverTransactionId.sendResponse(response);
            logger.info((Object)"shootist:  Sending OK.");
            logger.info((Object)("Dialog State = " + dialog.getState()));
        }
        catch (Exception ex) {
            TestHarness.fail(ex.getMessage());
            System.exit(0);
        }
    }

    public void processResponse(ResponseEvent responseReceivedEvent) {
        logger.info((Object)"Got a response");
        Response response = responseReceivedEvent.getResponse();
        ClientTransaction tid = responseReceivedEvent.getClientTransaction();
        CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
        logger.info((Object)("Response received : Status Code = " + response.getStatusCode() + " " + cseq));
        if (cseq.getMethod() == "PRACK") {
            this.prackConfirmed = true;
        }
        if (tid == null) {
            logger.info((Object)"Stray response -- dropping ");
            return;
        }
        logger.info((Object)("transaction state is " + tid.getState()));
        logger.info((Object)("Dialog = " + tid.getDialog()));
        logger.info((Object)("Dialog State is " + tid.getDialog().getState()));
        SipProvider provider = (SipProvider)responseReceivedEvent.getSource();
        this.dialog = tid.getDialog();
        try {
            if (response.getStatusCode() == 200) {
                if (cseq.getMethod().equals("INVITE")) {
                    Request ackRequest = this.dialog.createAck(((CSeqHeader)response.getHeader("CSeq")).getSeqNumber());
                    logger.info((Object)"Sending ACK");
                    this.dialog.sendAck(ackRequest);
                }
            } else if (response.getStatusCode() == 183) {
                this.prackTriggerReceived = true;
                RequireHeader requireHeader = (RequireHeader)response.getHeader("Require");
                if (requireHeader.getOptionTag().equalsIgnoreCase("100rel")) {
                    Dialog dialog = tid.getDialog();
                    Request prackRequest = dialog.createPrack(response);
                    SipURI requestURI = addressFactory.createSipURI(this.toUser, "127.0.0.1:5080");
                    prackRequest.setRequestURI((URI)requestURI);
                    ClientTransaction ct = provider.getNewClientTransaction(prackRequest);
                    dialog.sendRequest(ct);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestHarness.fail("Unexpected exception " + ex.getMessage());
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        logger.info((Object)"Transaction Time out");
    }

    public void sendInvite() {
        try {
            String fromName = "BigGuy";
            String fromSipAddress = "here.com";
            String fromDisplayName = "The Master Blaster";
            String toSipAddress = "there.com";
            String toDisplayName = "The Little Blister";
            SipURI fromAddress = addressFactory.createSipURI(fromName, fromSipAddress);
            Address fromNameAddress = addressFactory.createAddress((URI)fromAddress);
            fromNameAddress.setDisplayName(fromDisplayName);
            FromHeader fromHeader = headerFactory.createFromHeader(fromNameAddress, "12345");
            SipURI toAddress = addressFactory.createSipURI(this.toUser, toSipAddress);
            Address toNameAddress = addressFactory.createAddress((URI)toAddress);
            toNameAddress.setDisplayName(toDisplayName);
            ToHeader toHeader = headerFactory.createToHeader(toNameAddress, null);
            SipURI requestURI = addressFactory.createSipURI(this.toUser, "127.0.0.1:5080");
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            ViaHeader viaHeader = headerFactory.createViaHeader("127.0.0.1", sipProvider.getListeningPoint(this.transport).getPort(), this.transport, null);
            viaHeaders.add(viaHeader);
            ContentTypeHeader contentTypeHeader = headerFactory.createContentTypeHeader("application", "sdp");
            CallIdHeader callIdHeader = sipProvider.getNewCallId();
            callIdHeader = headerFactory.createCallIdHeader(callIdHeader.getCallId());
            CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(1L, "INVITE");
            MaxForwardsHeader maxForwards = headerFactory.createMaxForwardsHeader(70);
            Request request = messageFactory.createRequest((URI)requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
            String host = "127.0.0.1";
            SipURI contactUrl = addressFactory.createSipURI(fromName, host);
            ListeningPoint lp = sipProvider.getListeningPoint(this.transport);
            contactUrl.setPort(lp.getPort());
            SipURI contactURI = addressFactory.createSipURI(fromName, host);
            contactURI.setPort(sipProvider.getListeningPoint(this.transport).getPort());
            Address contactAddress = addressFactory.createAddress((URI)contactURI);
            contactAddress.setDisplayName(fromName);
            this.contactHeader = headerFactory.createContactHeader(contactAddress);
            request.addHeader((Header)this.contactHeader);
            RequireHeader requireHeader = headerFactory.createRequireHeader("100rel");
            request.addHeader((Header)requireHeader);
            this.inviteTid = sipProvider.getNewClientTransaction(request);
            this.dialog = this.inviteTid.getDialog();
            this.inviteTid.sendRequest();
        }
        catch (Exception ex) {
            TestHarness.fail("sendInvite failed because of " + ex.getMessage());
        }
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.info((Object)("IOException happened for " + exceptionEvent.getHost() + " port = " + exceptionEvent.getPort()));
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        logger.info((Object)"Transaction terminated event recieved");
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        logger.info((Object)"dialogTerminatedEvent");
    }

    public void checkState() {
        TestHarness.assertTrue(this.prackTriggerReceived);
        TestHarness.assertTrue(this.prackConfirmed);
    }

    static {
        logger = Logger.getLogger((String)"test.tck");
    }
}

