/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.recroute;

import java.util.Hashtable;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import org.apache.log4j.Logger;
import test.tck.msgflow.callflows.ScenarioHarness;
import test.tck.msgflow.callflows.recroute.Proxy;
import test.tck.msgflow.callflows.recroute.Shootist;
import test.tck.msgflow.callflows.recroute.Shootme;

public class AbstractRecRouteTestCase
extends ScenarioHarness
implements SipListener {
    protected Shootist shootist;
    private static Logger logger = Logger.getLogger((String)"test.tck");
    protected Shootme shootme;
    private Proxy proxy;

    public AbstractRecRouteTestCase() {
        super("TCPRecRouteTest", true);
        try {
            this.providerTable = new Hashtable();
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected exception", (Throwable)ex);
            AbstractRecRouteTestCase.fail("unexpected exception ");
        }
    }

    public void setUp() {
        try {
            super.setUp(false);
            this.shootist = new Shootist(5060, 5070, this.getTiProtocolObjects());
            SipProvider shootistProvider = this.shootist.createSipProvider();
            this.providerTable.put(shootistProvider, this.shootist);
            shootistProvider.addSipListener((SipListener)this);
            this.shootme = new Shootme(5080, this.getTiProtocolObjects());
            SipProvider shootmeProvider = this.shootme.createProvider();
            this.providerTable.put(shootmeProvider, this.shootme);
            shootmeProvider.addSipListener((SipListener)this);
            this.proxy = new Proxy(5070, this.getRiProtocolObjects());
            SipProvider provider = this.proxy.createSipProvider();
            this.providerTable.put(provider, this.proxy);
            provider.addSipListener((SipListener)this);
            this.getTiProtocolObjects().start();
            if (this.getTiProtocolObjects() != this.getRiProtocolObjects()) {
                this.getRiProtocolObjects().start();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected exception", (Throwable)ex);
            AbstractRecRouteTestCase.fail("unexpected exception ");
        }
    }

    public void tearDown() {
        try {
            Thread.sleep(5000L);
            this.shootist.checkState();
            this.shootme.checkState();
            this.proxy.checkState();
            super.tearDown();
            Thread.sleep(4000L);
            this.providerTable.clear();
            super.logTestCompleted();
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected exception", (Throwable)ex);
            AbstractRecRouteTestCase.fail("unexpected exception ");
        }
    }

    static {
        if (!logger.isAttached(console)) {
            logger.addAppender(console);
        }
    }
}

