/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.recroute;

import javax.sip.ClientTransaction;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.Header;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;

public class Proxy
extends TestHarness
implements SipListener {
    private static String host = "127.0.0.1";
    private int port = 5070;
    private SipProvider sipProvider;
    private static String unexpectedException = "Unexpected exception";
    private static Logger logger = Logger.getLogger((String)"test.tck");
    private ProtocolObjects protocolObjects;
    private boolean ackSeen;
    private boolean inviteSeen;
    private boolean byeSeen;
    private int infoCount = 0;

    public void checkState() {
        TestHarness.assertTrue("INVITE should be seen by proxy", this.inviteSeen);
        TestHarness.assertTrue("Should see two INFO messages", this.infoCount == 2);
        TestHarness.assertTrue("BYE should be seen by proxy", this.byeSeen);
        TestHarness.assertTrue("ACK should be seen by proxy", this.ackSeen);
    }

    public void processRequest(RequestEvent requestEvent) {
        try {
            Request request = requestEvent.getRequest();
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            if (request.getMethod().equals("INVITE")) {
                this.inviteSeen = true;
                ListeningPoint lp = sipProvider.getListeningPoint(this.protocolObjects.transport);
                String host = lp.getIPAddress();
                int port = lp.getPort();
                ServerTransaction st = null;
                if (requestEvent.getServerTransaction() == null) {
                    st = sipProvider.getNewServerTransaction(request);
                }
                Request newRequest = (Request)request.clone();
                SipURI sipUri = this.protocolObjects.addressFactory.createSipURI("UA1", "127.0.0.1");
                sipUri.setPort(5080);
                sipUri.setLrParam();
                sipUri.setTransportParam(this.protocolObjects.transport);
                Address address = this.protocolObjects.addressFactory.createAddress("client1", (URI)sipUri);
                RouteHeader rheader = this.protocolObjects.headerFactory.createRouteHeader(address);
                newRequest.addFirst((Header)rheader);
                ViaHeader viaHeader = this.protocolObjects.headerFactory.createViaHeader(host, port, this.protocolObjects.transport, null);
                newRequest.addFirst((Header)viaHeader);
                ClientTransaction ct1 = sipProvider.getNewClientTransaction(newRequest);
                sipUri = this.protocolObjects.addressFactory.createSipURI("proxy", "127.0.0.1");
                address = this.protocolObjects.addressFactory.createAddress("proxy", (URI)sipUri);
                sipUri.setPort(5070);
                sipUri.setLrParam();
                sipUri.setTransportParam(this.protocolObjects.transport);
                RecordRouteHeader recordRoute = this.protocolObjects.headerFactory.createRecordRouteHeader(address);
                newRequest.addHeader((Header)recordRoute);
                ct1.setApplicationData((Object)st);
                ct1.sendRequest();
                TestHarness.assertNull((Object)ct1.getDialog());
            } else if (request.getMethod().equals("ACK")) {
                Request newRequest = (Request)request.clone();
                newRequest.removeFirst("Route");
                ViaHeader viaHeader = this.protocolObjects.headerFactory.createViaHeader(host, this.port, this.protocolObjects.transport, null);
                newRequest.addFirst((Header)viaHeader);
                this.ackSeen = true;
                logger.debug((Object)("PROXY : sendingAck " + newRequest));
                sipProvider.sendRequest(newRequest);
            } else {
                logger.debug((Object)("proxy: Got a request\n" + request));
                if (request.getMethod().equals("BYE")) {
                    this.byeSeen = true;
                }
                if (request.getMethod().equals("INFO")) {
                    ++this.infoCount;
                }
                if (requestEvent.getServerTransaction() == null) {
                    TestHarness.assertNull("Dialog should be null", requestEvent.getDialog());
                    ServerTransaction stx = sipProvider.getNewServerTransaction(request);
                    Request newRequest = (Request)request.clone();
                    newRequest.removeFirst("Route");
                    ViaHeader viaHeader = this.protocolObjects.headerFactory.createViaHeader(host, this.port, this.protocolObjects.transport, null);
                    newRequest.addFirst((Header)viaHeader);
                    ClientTransaction ctx = sipProvider.getNewClientTransaction(newRequest);
                    ctx.setApplicationData((Object)stx);
                    stx.setApplicationData((Object)ctx);
                    ctx.sendRequest();
                } else {
                    logger.debug((Object)("Saw a retransmission? State = " + requestEvent.getServerTransaction().getState()));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Unexpected error forwarding request", (Throwable)ex);
            TestHarness.fail("Unexpected exception forwarding request");
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        try {
            Response response = responseEvent.getResponse();
            CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
            logger.debug((Object)("ClientTxID = " + responseEvent.getClientTransaction() + " client tx id " + ((ViaHeader)response.getHeader("Via")).getBranch() + " CSeq header = " + response.getHeader("CSeq") + " status code = " + response.getStatusCode()));
            if (response.getStatusCode() == 100) {
                return;
            }
            ClientTransaction ct = responseEvent.getClientTransaction();
            if (ct != null) {
                ServerTransaction st = (ServerTransaction)ct.getApplicationData();
                Response newResponse = (Response)response.clone();
                newResponse.removeFirst("Via");
                if (st.getState() != TransactionState.TERMINATED) {
                    st.sendResponse(newResponse);
                }
                TestHarness.assertNull((Object)st.getDialog());
            } else {
                Response newResponse = (Response)response.clone();
                newResponse.removeFirst("Via");
                SipProvider sipProvider = (SipProvider)responseEvent.getSource();
                sipProvider.sendResponse(newResponse);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestHarness.fail("unexpected exception", ex);
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        logger.error((Object)"Timeout occured");
        Proxy.fail("unexpected event");
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.error((Object)"IOException occured");
        Proxy.fail("unexpected exception io exception");
    }

    public SipProvider createSipProvider() {
        try {
            ListeningPoint listeningPoint = this.protocolObjects.sipStack.createListeningPoint(host, this.port, this.protocolObjects.transport);
            this.sipProvider = this.protocolObjects.sipStack.createSipProvider(listeningPoint);
            this.sipProvider.setAutomaticDialogSupportEnabled(false);
            return this.sipProvider;
        }
        catch (Exception ex) {
            logger.error((Object)unexpectedException, (Throwable)ex);
            Proxy.fail(unexpectedException);
            return null;
        }
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        logger.debug((Object)"Transaction terminated event occured -- cleaning up");
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        Proxy.fail("unexpected event");
    }

    public Proxy(int myPort, ProtocolObjects protocolObjects) {
        this.port = myPort;
        this.protocolObjects = protocolObjects;
    }
}

