/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.redirect;

import java.util.ArrayList;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;

public class Shootist
extends TestHarness
implements SipListener {
    private SipProvider sipProvider;
    private ProtocolObjects protocolObjects;
    private ContactHeader contactHeader;
    private ListeningPoint listeningPoint;
    private ClientTransaction inviteTid;
    private Dialog dialog;
    public static final int myPort = 5080;
    private int peerPort;
    private String peerHostPort;
    private int dialogTerminatedCount;
    private int transctionTerminatedCount;
    private int transactionCount;
    private int dialogCount;
    private boolean byeReceived;
    private boolean redirectReceived;
    private SipURI requestURI;
    private static Logger logger = Logger.getLogger(Shootist.class);

    public void processRequest(RequestEvent requestReceivedEvent) {
        Request request = requestReceivedEvent.getRequest();
        ServerTransaction serverTransactionId = requestReceivedEvent.getServerTransaction();
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + this.protocolObjects.sipStack.getStackName() + " with server transaction id " + serverTransactionId));
        if (request.getMethod().equals("BYE")) {
            this.processBye(request, serverTransactionId);
        }
    }

    public void processBye(Request request, ServerTransaction serverTransactionId) {
        try {
            logger.info((Object)("shootist:  got a bye . ServerTxId = " + serverTransactionId));
            this.byeReceived = true;
            if (serverTransactionId == null) {
                logger.info((Object)"shootist:  null TID.");
                return;
            }
            Dialog dialog = serverTransactionId.getDialog();
            Shootist.assertTrue(dialog == this.dialog);
            logger.info((Object)("Dialog State = " + dialog.getState()));
            Response response = this.protocolObjects.messageFactory.createResponse(200, request);
            serverTransactionId.sendResponse(response);
            ++this.transactionCount;
            logger.info((Object)"shootist:  Sending OK.");
            logger.info((Object)("Dialog State = " + dialog.getState()));
            ViaHeader via = (ViaHeader)request.getHeader("Via");
            if (via.getTransport().equalsIgnoreCase("UDP")) {
                Shootist.assertEquals("Check for Transaction State of Completed", TransactionState.COMPLETED, serverTransactionId.getState());
            } else {
                Shootist.assertEquals("Check for Transaction State of Completed", TransactionState.TERMINATED, serverTransactionId.getState());
            }
            Shootist.assertEquals("Check for Dialog state of terminated", DialogState.TERMINATED, dialog.getState());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void processResponse(ResponseEvent responseReceivedEvent) {
        logger.info((Object)"Got a response");
        Response response = responseReceivedEvent.getResponse();
        ClientTransaction tid = responseReceivedEvent.getClientTransaction();
        CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
        logger.info((Object)("Response received : Status Code = " + response.getStatusCode() + " " + cseq));
        if (tid == null) {
            logger.info((Object)"Stray response -- dropping ");
            return;
        }
        logger.info((Object)("transaction state is " + tid.getState()));
        logger.info((Object)("Dialog = " + tid.getDialog()));
        logger.info((Object)("Dialog State is " + tid.getDialog().getState()));
        try {
            if (response.getStatusCode() == 200) {
                logger.info((Object)("response = " + response));
                if (cseq.getMethod().equals("INVITE")) {
                    Request ackRequest = this.dialog.createAck(cseq.getSeqNumber());
                    logger.info((Object)"Sending ACK");
                    this.dialog.sendAck(ackRequest);
                }
            } else if (response.getStatusCode() == 302) {
                Shootist.assertTrue(tid.getDialog().getState() == DialogState.TERMINATED);
                Shootist.assertSame("Dialog Identity should be preserved", tid.getDialog(), this.dialog);
                this.redirectReceived = true;
                if (cseq.getMethod().equals("INVITE")) {
                    ContactHeader contHdr = (ContactHeader)response.getHeader("Contact");
                    FromHeader from = (FromHeader)response.getHeader("From");
                    ToHeader to = (ToHeader)response.getHeader("To").clone();
                    to.removeParameter("tag");
                    CallIdHeader callID = (CallIdHeader)response.getHeader("Call-ID");
                    long seqNo = ((CSeqHeader)response.getHeader("CSeq")).getSeqNumber();
                    logger.info((Object)("seqNo = " + seqNo));
                    CSeqHeader cseqNew = this.protocolObjects.headerFactory.createCSeqHeader(++seqNo, "INVITE");
                    ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
                    ViaHeader viaHeader = this.protocolObjects.headerFactory.createViaHeader("127.0.0.1", this.sipProvider.getListeningPoint(this.protocolObjects.transport).getPort(), this.protocolObjects.transport, null);
                    viaHeaders.add(viaHeader);
                    MaxForwardsHeader maxForwardsHeader = this.protocolObjects.headerFactory.createMaxForwardsHeader(10);
                    SipURI newUri = (SipURI)this.requestURI.clone();
                    newUri.setParameter("redirection", "true");
                    Request invRequest = this.protocolObjects.messageFactory.createRequest((URI)newUri, "INVITE", callID, cseqNew, from, to, viaHeaders, maxForwardsHeader);
                    SipURI contactURI = this.protocolObjects.addressFactory.createSipURI(null, this.listeningPoint.getIPAddress());
                    contactURI.setPort(this.listeningPoint.getPort());
                    contactURI.setTransportParam(this.protocolObjects.transport);
                    Address address = this.protocolObjects.addressFactory.createAddress((URI)contactURI);
                    ContactHeader contact = this.protocolObjects.headerFactory.createContactHeader(address);
                    invRequest.addHeader((Header)contact);
                    ContactHeader chdr = (ContactHeader)response.getHeader("Contact");
                    SipURI sipUri = (SipURI)chdr.getAddress().getURI();
                    sipUri.setLrParam();
                    RouteHeader routeHeader = this.protocolObjects.headerFactory.createRouteHeader(chdr.getAddress());
                    invRequest.addHeader((Header)routeHeader);
                    logger.info((Object)("Sending INVITE to " + contHdr.getAddress().getURI().toString()));
                    this.inviteTid = this.sipProvider.getNewClientTransaction(invRequest);
                    ++this.transactionCount;
                    logger.info((Object)("New TID = " + this.inviteTid));
                    Thread.sleep(500L);
                    this.inviteTid.sendRequest();
                    logger.info((Object)("sendReqeust succeeded " + this.inviteTid));
                    Dialog dialog = this.inviteTid.getDialog();
                    Shootist.assertTrue("Stack must allocate a new dialog", dialog != this.dialog);
                    ++this.dialogCount;
                    this.dialog = dialog;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Shootist.fail("unexpeced exception");
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        logger.info((Object)"Transaction Time out");
        Shootist.fail("Unexpected event");
    }

    public SipProvider createProvider() throws Exception {
        logger.info((Object)"Shootist: createProvider()");
        this.listeningPoint = this.protocolObjects.sipStack.createListeningPoint("127.0.0.1", 5080, this.protocolObjects.transport);
        this.sipProvider = this.protocolObjects.sipStack.createSipProvider(this.listeningPoint);
        Shootist.assertTrue("listening point should be the same as what the provider returns for this transport", this.listeningPoint == this.sipProvider.getListeningPoint(this.protocolObjects.transport));
        return this.sipProvider;
    }

    public void sendInvite() {
        try {
            String fromName = "BigGuy";
            String fromSipAddress = "here.com";
            String fromDisplayName = "The Master Blaster";
            String toSipAddress = "there.com";
            String toUser = "LittleGuy";
            String toDisplayName = "The Little Blister";
            SipURI fromAddress = this.protocolObjects.addressFactory.createSipURI(fromName, fromSipAddress);
            Address fromNameAddress = this.protocolObjects.addressFactory.createAddress((URI)fromAddress);
            fromNameAddress.setDisplayName(fromDisplayName);
            FromHeader fromHeader = this.protocolObjects.headerFactory.createFromHeader(fromNameAddress, "12345");
            SipURI toAddress = this.protocolObjects.addressFactory.createSipURI(toUser, toSipAddress);
            Address toNameAddress = this.protocolObjects.addressFactory.createAddress((URI)toAddress);
            toNameAddress.setDisplayName(toDisplayName);
            ToHeader toHeader = this.protocolObjects.headerFactory.createToHeader(toNameAddress, null);
            this.requestURI = this.protocolObjects.addressFactory.createSipURI(toUser, this.peerHostPort);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            ViaHeader viaHeader = this.protocolObjects.headerFactory.createViaHeader("127.0.0.1", this.sipProvider.getListeningPoint(this.protocolObjects.transport).getPort(), this.protocolObjects.transport, null);
            viaHeaders.add(viaHeader);
            ContentTypeHeader contentTypeHeader = this.protocolObjects.headerFactory.createContentTypeHeader("application", "sdp");
            CallIdHeader callIdHeader = this.sipProvider.getNewCallId();
            callIdHeader = this.protocolObjects.headerFactory.createCallIdHeader(callIdHeader.getCallId());
            CSeqHeader cSeqHeader = this.protocolObjects.headerFactory.createCSeqHeader(1L, "INVITE");
            MaxForwardsHeader maxForwards = this.protocolObjects.headerFactory.createMaxForwardsHeader(70);
            Request request = this.protocolObjects.messageFactory.createRequest((URI)this.requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
            String host = "127.0.0.1";
            SipURI contactUrl = this.protocolObjects.addressFactory.createSipURI(fromName, host);
            contactUrl.setPort(this.listeningPoint.getPort());
            contactUrl.setTransportParam(this.protocolObjects.transport);
            Address contactAddress = this.protocolObjects.addressFactory.createAddress((URI)contactUrl);
            contactUrl.setLrParam();
            contactAddress.setDisplayName(fromName);
            this.contactHeader = this.protocolObjects.headerFactory.createContactHeader(contactAddress);
            request.addHeader((Header)this.contactHeader);
            SipURI uri = this.protocolObjects.addressFactory.createSipURI(null, "127.0.0.1");
            uri.setLrParam();
            uri.setTransportParam(this.protocolObjects.transport);
            uri.setPort(this.peerPort);
            Address address = this.protocolObjects.addressFactory.createAddress((URI)uri);
            RouteHeader routeHeader = this.protocolObjects.headerFactory.createRouteHeader(address);
            request.addHeader((Header)routeHeader);
            Header callInfoHeader = this.protocolObjects.headerFactory.createHeader("Call-Info", "<http://www.antd.nist.gov>");
            request.addHeader(callInfoHeader);
            this.inviteTid = this.sipProvider.getNewClientTransaction(request);
            ++this.transactionCount;
            logger.info((Object)("client tx = " + this.inviteTid));
            this.dialog = this.inviteTid.getDialog();
            ++this.dialogCount;
            Shootist.assertTrue(this.dialog != null);
            this.inviteTid.sendRequest();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            Shootist.fail("unexpected exception");
        }
    }

    public Shootist(ProtocolObjects protocolObjects) {
        this.protocolObjects = protocolObjects;
        this.peerPort = 5070;
        this.peerHostPort = "127.0.0.1:" + this.peerPort;
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.info((Object)("IOException happened for " + exceptionEvent.getHost() + " port = " + exceptionEvent.getPort()));
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        logger.info((Object)("Transaction terminated event recieved for " + transactionTerminatedEvent.getClientTransaction()));
        ++this.transctionTerminatedCount;
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        ++this.dialogTerminatedCount;
    }

    public void checkState() {
        logger.info((Object)("byeRecieved = " + this.byeReceived));
        logger.info((Object)("redirectRecieved" + this.redirectReceived));
        Shootist.assertTrue(this.byeReceived && this.redirectReceived);
    }
}

