/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.redirect;

import java.util.Timer;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;

public class Shootme
extends TestHarness
implements SipListener {
    private ProtocolObjects protocolObjects;
    private static final String myAddress = "127.0.0.1";
    public static final int myPort = 5070;
    protected ServerTransaction inviteTid;
    private Response okResponse;
    private Request inviteRequest;
    private Dialog dialog;
    private SipProvider sipProvider;
    private int inviteCount = 0;
    private int dialogTerminationCount = 0;
    private int dialogCount;
    private int byeOkRecieved;
    private int ackCount;
    private static Logger logger = Logger.getLogger(Shootme.class);
    protected static final String usageString = "java examples.shootist.Shootist \n>>>> is your class path set to the root?";

    public void processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        ServerTransaction serverTransactionId = requestEvent.getServerTransaction();
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + this.protocolObjects.sipStack.getStackName() + " with server transaction id " + serverTransactionId));
        if (request.getMethod().equals("INVITE")) {
            this.processInvite(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("ACK")) {
            this.processAck(requestEvent, serverTransactionId);
        } else {
            Shootme.fail("unexpected request recieved");
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        if (((CSeqHeader)responseEvent.getResponse().getHeader("CSeq")).getMethod().equals("BYE")) {
            ++this.byeOkRecieved;
        } else {
            Shootme.fail("unexpected response received");
        }
    }

    public void processAck(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        try {
            ++this.ackCount;
            logger.debug((Object)"shootme: got an ACK ");
            logger.debug((Object)("Dialog State = " + this.dialog.getState() + " sending BYE "));
            if (this.dialog.getState() == DialogState.CONFIRMED) {
                Request bye = this.dialog.createRequest("BYE");
                ClientTransaction ct = this.sipProvider.getNewClientTransaction(bye);
                this.dialog.sendRequest(ct);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected exception", (Throwable)ex);
            Shootme.fail("unexpected exception sending bye");
        }
    }

    public void processInvite(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        try {
            Dialog dialog;
            ++this.inviteCount;
            logger.info((Object)("shootme: got an Invite " + this.inviteCount));
            Shootme.assertTrue(request.getHeader("Contact") != null);
            Response response = this.protocolObjects.messageFactory.createResponse(100, request);
            ToHeader toHeader = (ToHeader)response.getHeader("To");
            Address address = this.protocolObjects.addressFactory.createAddress("Shootme <sip:127.0.0.1:5070;transport=" + this.protocolObjects.transport + ">");
            ServerTransaction st = requestEvent.getServerTransaction();
            if (st == null) {
                st = sipProvider.getNewServerTransaction(request);
            }
            Shootme.assertTrue(this.dialog != (dialog = st.getDialog()));
            ++this.dialogCount;
            this.dialog = dialog;
            logger.info((Object)("Shootme: dialog = " + dialog));
            st.sendResponse(response);
            ContactHeader contactHeader = this.protocolObjects.headerFactory.createContactHeader(address);
            if (((SipURI)request.getRequestURI()).getParameter("redirection") == null) {
                Response moved = this.protocolObjects.messageFactory.createResponse(302, request);
                moved.addHeader((Header)contactHeader);
                toHeader = (ToHeader)moved.getHeader("To");
                toHeader.setTag("4321");
                st.sendResponse(moved);
                Shootme.assertTrue("dialog state should be terminated", dialog.getState() == DialogState.TERMINATED);
            } else {
                Response ringing = this.protocolObjects.messageFactory.createResponse(180, request);
                toHeader = (ToHeader)ringing.getHeader("To");
                toHeader.setTag("5432");
                st.sendResponse(ringing);
                Shootme.assertEquals("server tx state should be proceeding", st.getState(), TransactionState.PROCEEDING);
                this.okResponse = this.protocolObjects.messageFactory.createResponse(200, request);
                toHeader = (ToHeader)this.okResponse.getHeader("To");
                toHeader.setTag("5432");
                this.okResponse.addHeader((Header)contactHeader);
                this.inviteTid = st;
                this.inviteRequest = request;
                new Timer().schedule((TimerTask)new MyTimerTask(this), 500L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Shootme.fail("Error sending response to INVITE");
        }
    }

    private void sendInviteOK() {
        try {
            Shootme.assertTrue(this.inviteTid.getState() == TransactionState.PROCEEDING);
            this.inviteTid.sendResponse(this.okResponse);
            logger.info((Object)("Dialog = " + this.inviteTid.getDialog()));
            logger.info((Object)("shootme: Dialog state after response: " + this.okResponse.getStatusCode() + " " + this.inviteTid.getDialog().getState()));
            Shootme.assertEquals("invite tx state should be terminated", this.inviteTid.getState(), TransactionState.TERMINATED);
        }
        catch (SipException ex) {
            logger.error((Object)"unexpected exception", (Throwable)ex);
            Shootme.fail("unexpected exception");
        }
        catch (InvalidArgumentException ex) {
            logger.error((Object)"unexpceted exception", (Throwable)ex);
            Shootme.fail("unexpected exception");
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        Object transaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        logger.info((Object)("state = " + transaction.getState()));
        logger.info((Object)("dialog = " + transaction.getDialog()));
        logger.info((Object)("dialogState = " + transaction.getDialog().getState()));
        logger.info((Object)"Transaction Time out");
        Shootme.fail("unexpected timeout occured");
    }

    public SipProvider createProvider() throws Exception {
        ListeningPoint lp = this.protocolObjects.sipStack.createListeningPoint(myAddress, 5070, this.protocolObjects.transport);
        this.sipProvider = this.protocolObjects.sipStack.createSipProvider(lp);
        return this.sipProvider;
    }

    public Shootme(ProtocolObjects protocolObjects) {
        this.protocolObjects = protocolObjects;
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.info((Object)"IOException");
        Shootme.fail("unexpected exception");
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        logger.info((Object)"Transaction terminated event recieved");
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        logger.info((Object)("Dialog terminated event recieved dialog = " + dialogTerminatedEvent.getDialog()));
        ++this.dialogTerminationCount;
    }

    public void checkState() {
        Shootme.assertTrue(this.inviteCount == 2 && this.ackCount >= 1 && this.byeOkRecieved >= 1);
    }

    class MyTimerTask
    extends TimerTask {
        Shootme shootme;

        public MyTimerTask(Shootme shootme2) {
            this.shootme = shootme2;
        }

        public void run() {
            this.shootme.sendInviteOK();
        }
    }
}

