/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.refer;

import javax.sip.SipListener;
import javax.sip.SipProvider;
import org.apache.log4j.Logger;
import test.tck.msgflow.callflows.ScenarioHarness;
import test.tck.msgflow.callflows.refer.Referee;
import test.tck.msgflow.callflows.refer.Referrer;

public abstract class AbstractReferTestCase
extends ScenarioHarness
implements SipListener {
    protected Referee referee;
    protected Referrer referrer;
    private static Logger logger = Logger.getLogger((String)"test.tck");

    public AbstractReferTestCase() {
        super("refer", true);
    }

    public void setUp() throws Exception {
        try {
            super.setUp();
            logger.info((Object)"ReferTest: setup()");
            this.referee = new Referee(this.getTiProtocolObjects());
            SipProvider refereeProvider = this.referee.createProvider();
            this.providerTable.put(refereeProvider, this.referee);
            this.referrer = new Referrer(this.getRiProtocolObjects());
            SipProvider referrerProvider = this.referrer.createProvider();
            this.providerTable.put(referrerProvider, this.referrer);
            refereeProvider.addSipListener((SipListener)this);
            referrerProvider.addSipListener((SipListener)this);
            if (this.getTiProtocolObjects() != this.getRiProtocolObjects()) {
                this.getTiProtocolObjects().start();
            }
            this.getRiProtocolObjects().start();
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected excecption ", (Throwable)ex);
            AbstractReferTestCase.fail("unexpected exception");
        }
    }

    public void tearDown() throws Exception {
        try {
            Thread.sleep(4000L);
            super.tearDown();
            Thread.sleep(1000L);
            this.providerTable.clear();
            ScenarioHarness.assertTrue(" Should have at least 3 NOTIFY", this.referrer.count >= 3);
            this.logTestCompleted();
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected exception", (Throwable)ex);
            AbstractReferTestCase.fail("unexpected exception ");
        }
        super.tearDown();
    }

    static {
        if (!logger.isAttached(console)) {
            logger.addAppender(console);
        }
    }
}

