/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.refer;

import java.text.ParseException;
import java.util.ArrayList;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ReferToHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;

public class Referee
implements SipListener {
    private static AddressFactory addressFactory;
    private static MessageFactory messageFactory;
    private static HeaderFactory headerFactory;
    private static SipStack sipStack;
    public static final int myPort = 5070;
    protected SipProvider mySipProvider;
    protected Dialog dialog;
    private static Logger logger;
    private boolean tryingSent;
    private EventHeader referEvent;
    private String transport;

    public Referee(ProtocolObjects protObjects) {
        addressFactory = protObjects.addressFactory;
        messageFactory = protObjects.messageFactory;
        headerFactory = protObjects.headerFactory;
        sipStack = protObjects.sipStack;
        this.transport = protObjects.transport;
    }

    public void processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        ServerTransaction serverTransactionId = requestEvent.getServerTransaction();
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + sipStack.getStackName() + " with server transaction id " + serverTransactionId + " and dialog id " + requestEvent.getDialog()));
        logger.info((Object)request.toString());
        if (request.getMethod().equals("REFER")) {
            try {
                this.processRefer(requestEvent, serverTransactionId);
            }
            catch (Exception e) {
                logger.info((Object)("Referee failed processing REFER, because of " + e.getMessage()), (Throwable)e);
                TestHarness.fail("Referee failed processing REFER, because of " + e.getMessage());
            }
        } else {
            TestHarness.fail("Not a REFER request but:" + request.getMethod());
        }
    }

    public void processRefer(RequestEvent requestEvent, ServerTransaction serverTransaction) throws ParseException, SipException, InvalidArgumentException {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request refer = requestEvent.getRequest();
        logger.info((Object)"referee: got an REFER sending Accepted");
        logger.info((Object)("referee:  " + refer.getMethod()));
        this.dialog = requestEvent.getDialog();
        logger.info((Object)("referee : dialog = " + requestEvent.getDialog()));
        ReferToHeader refTo = (ReferToHeader)refer.getHeader("Refer-To");
        if (refTo == null) {
            Response bad = messageFactory.createResponse(400, refer);
            bad.setReasonPhrase("Missing Refer-To");
            sipProvider.sendResponse(bad);
            TestHarness.fail("Bad REFER request. Missing Refer-To.");
        }
        if (!this.tryingSent && "udp".equalsIgnoreCase(this.transport)) {
            this.tryingSent = true;
            sipProvider.sendResponse(messageFactory.createResponse(100, refer));
            return;
        }
        Response response = null;
        ServerTransaction st = requestEvent.getServerTransaction();
        if (st == null) {
            st = sipProvider.getNewServerTransaction(refer);
        }
        String toTag = Integer.toHexString((int)(Math.random() * 2.147483647E9));
        response = messageFactory.createResponse(202, refer);
        ToHeader toHeader = (ToHeader)response.getHeader("To");
        TestHarness.assertNull("To-tag!=null but no dialog match! My dialog=" + this.dialog, toHeader.getTag());
        toHeader.setTag(toTag);
        this.dialog = st.getDialog();
        this.dialog.terminateOnBye(false);
        if (this.dialog != null) {
            logger.info((Object)("Dialog " + this.dialog));
            logger.info((Object)("Dialog state " + this.dialog.getState()));
            logger.info((Object)("local tag=" + this.dialog.getLocalTag()));
            logger.info((Object)("remote tag=" + this.dialog.getRemoteTag()));
        }
        Address address = addressFactory.createAddress("Referee <sip:127.0.0.1>");
        ((SipURI)address.getURI()).setPort(this.mySipProvider.getListeningPoint(this.transport).getPort());
        ContactHeader contactHeader = headerFactory.createContactHeader(address);
        response.addHeader((Header)contactHeader);
        ExpiresHeader expires = (ExpiresHeader)refer.getHeader("Expires");
        if (expires == null) {
            expires = headerFactory.createExpiresHeader(30);
        }
        response.addHeader((Header)expires);
        TestHarness.assertNull((Object)this.dialog.getState());
        st.sendResponse(response);
        TestHarness.assertEquals(DialogState.CONFIRMED, this.dialog.getState());
        this.referEvent = headerFactory.createEventHeader("refer");
        long id = ((CSeqHeader)refer.getHeader("CSeq")).getSeqNumber();
        this.referEvent.setEventId(Long.toString(id));
        this.sendInvite(refTo);
    }

    private void sendNotify(int code, String reason) throws SipException, ParseException {
        Request notifyRequest = this.dialog.createRequest("NOTIFY");
        String state = "pending";
        if (code > 100 && code < 200) {
            state = "active";
        } else if (code >= 200) {
            state = "terminated";
        }
        SubscriptionStateHeader sstate = headerFactory.createSubscriptionStateHeader(state);
        if (state == "terminated") {
            sstate.setReasonCode("noresource");
        }
        notifyRequest.addHeader((Header)sstate);
        notifyRequest.setHeader((Header)this.referEvent);
        Address address = addressFactory.createAddress("Referee <sip:127.0.0.1>");
        ((SipURI)address.getURI()).setPort(this.mySipProvider.getListeningPoint(this.transport).getPort());
        ((SipURI)address.getURI()).setTransportParam(this.transport);
        ContactHeader contactHeader = headerFactory.createContactHeader(address);
        notifyRequest.setHeader((Header)contactHeader);
        ClientTransaction ct2 = this.mySipProvider.getNewClientTransaction(notifyRequest);
        ContentTypeHeader ct = headerFactory.createContentTypeHeader("message", "sipfrag");
        ct.setParameter("version", "2.0");
        notifyRequest.setContent((Object)("SIP/2.0 " + code + ' ' + reason), ct);
        this.dialog.sendRequest(ct2);
        logger.info((Object)("NOTIFY Branch ID " + ((ViaHeader)notifyRequest.getHeader("Via")).getParameter("branch")));
        logger.info((Object)("Dialog " + this.dialog));
        logger.info((Object)("Dialog state after NOTIFY: " + this.dialog.getState()));
    }

    public void processResponse(ResponseEvent responseReceivedEvent) {
        logger.info((Object)"Got a response");
        Response response = responseReceivedEvent.getResponse();
        ClientTransaction tid = responseReceivedEvent.getClientTransaction();
        if (tid != null) {
            logger.info((Object)("Response received with client transaction id " + tid + ":\n" + response.getStatusCode() + " cseq = " + response.getHeader("CSeq") + " dialog " + tid.getDialog()));
        } else {
            logger.info((Object)("Response received with client transaction id " + tid + ":\n" + response.getStatusCode() + " cseq = " + response.getHeader("CSeq") + " dialog " + responseReceivedEvent.getDialog()));
        }
        CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
        if (cseq.getMethod().equals("INVITE")) {
            try {
                this.sendNotify(response.getStatusCode(), response.getReasonPhrase());
            }
            catch (Exception e1) {
                TestHarness.fail("Failed to send notify, because of " + e1.getMessage());
            }
            if (response.getStatusCode() == 200) {
                try {
                    Request ack = tid.getDialog().createAck(cseq.getSeqNumber());
                    tid.getDialog().sendAck(ack);
                    if (tid.getDialog().getState() != DialogState.TERMINATED) {
                        Request bye = tid.getDialog().createRequest("BYE");
                        tid.getDialog().sendRequest(this.mySipProvider.getNewClientTransaction(bye));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Caught exception", (Throwable)e);
                    TestHarness.fail("Failed to send BYE request, because of " + e.getMessage());
                }
            }
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        Object transaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        logger.info((Object)("state = " + transaction.getState()));
        logger.info((Object)("dialog = " + transaction.getDialog()));
        logger.info((Object)("dialogState = " + transaction.getDialog().getState()));
        logger.info((Object)"Transaction Time out");
        TestHarness.fail("Transaction timeout");
    }

    public void sendInvite(ReferToHeader to) {
        try {
            String fromName = "Referee";
            String fromSipAddress = "here.com";
            String fromDisplayName = "The Master Blaster";
            SipURI fromAddress = addressFactory.createSipURI(fromName, fromSipAddress);
            Address fromNameAddress = addressFactory.createAddress((URI)fromAddress);
            fromNameAddress.setDisplayName(fromDisplayName);
            FromHeader fromHeader = headerFactory.createFromHeader(fromNameAddress, "12345");
            ToHeader toHeader = headerFactory.createToHeader(to.getAddress(), null);
            SipURI requestURI = (SipURI)to.getAddress().getURI();
            ListeningPoint lp = this.mySipProvider.getListeningPoint(this.transport);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            ViaHeader viaHeader = headerFactory.createViaHeader("127.0.0.1", lp.getPort(), this.transport, null);
            viaHeaders.add(viaHeader);
            CallIdHeader callIdHeader = this.mySipProvider.getNewCallId();
            callIdHeader = headerFactory.createCallIdHeader(callIdHeader.getCallId());
            CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(1L, "INVITE");
            MaxForwardsHeader maxForwards = headerFactory.createMaxForwardsHeader(70);
            Request request = messageFactory.createRequest((URI)requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
            String host = lp.getIPAddress();
            SipURI contactURI = addressFactory.createSipURI(fromName, host);
            contactURI.setPort(lp.getPort());
            contactURI.setTransportParam(this.transport);
            Address contactAddress = addressFactory.createAddress((URI)contactURI);
            contactAddress.setDisplayName(fromName);
            ContactHeader contactHeader = headerFactory.createContactHeader(contactAddress);
            request.addHeader((Header)contactHeader);
            ClientTransaction inviteTid = this.mySipProvider.getNewClientTransaction(request);
            logger.info((Object)("Invite Dialog = " + inviteTid.getDialog()));
            inviteTid.sendRequest();
        }
        catch (Throwable ex) {
            TestHarness.fail("Failed to send INVITE, because of " + ex);
        }
    }

    public SipProvider createProvider() throws Exception {
        ListeningPoint lp = sipStack.createListeningPoint("127.0.0.1", 5070, this.transport);
        this.mySipProvider = sipStack.createSipProvider(lp);
        logger.info((Object)("provider " + this.mySipProvider));
        return this.mySipProvider;
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.error((Object)("processIOEx:" + exceptionEvent));
        TestHarness.fail("unexpected event");
    }

    public void processTransactionTerminated(TransactionTerminatedEvent tte) {
        logger.info((Object)("transaction terminated:" + tte));
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        logger.info((Object)("dialog terminated:" + dialogTerminatedEvent));
    }

    static {
        logger = Logger.getLogger(Referee.class);
        try {
            logger.setLevel(Level.INFO);
            logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), "logs/refereeoutputlog.txt"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

