/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.refer;

import java.util.ArrayList;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ReferToHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;

public class Referrer
implements SipListener {
    private SipProvider sipProvider;
    private AddressFactory addressFactory;
    private MessageFactory messageFactory;
    private HeaderFactory headerFactory;
    private SipStack sipStack;
    private ContactHeader contactHeader;
    private String transport;
    public static final int myPort = 5080;
    public int count;
    private static Logger logger = Logger.getLogger(Referrer.class);
    private ClientTransaction subscribeTid;
    private ListeningPoint listeningPoint;

    public Referrer(ProtocolObjects protObjects) {
        this.addressFactory = protObjects.addressFactory;
        this.messageFactory = protObjects.messageFactory;
        this.headerFactory = protObjects.headerFactory;
        this.sipStack = protObjects.sipStack;
        this.transport = protObjects.transport;
    }

    public void processRequest(RequestEvent requestReceivedEvent) {
        Request request = requestReceivedEvent.getRequest();
        ServerTransaction serverTransactionId = requestReceivedEvent.getServerTransaction();
        String viaBranch = ((ViaHeader)request.getHeaders("Via").next()).getParameter("branch");
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + this.sipStack.getStackName() + " with server transaction id " + serverTransactionId + " branch ID = " + viaBranch));
        if (request.getMethod().equals("NOTIFY")) {
            this.processNotify(requestReceivedEvent, serverTransactionId);
        } else if (request.getMethod().equals("INVITE")) {
            this.processInvite(requestReceivedEvent);
        } else if (request.getMethod().equals("ACK")) {
            this.processAck(requestReceivedEvent);
        } else if (request.getMethod().equals("BYE")) {
            this.processBye(requestReceivedEvent);
        } else {
            TestHarness.fail("Unexpected request type:" + request.getMethod());
        }
    }

    private void processNotify(RequestEvent requestEvent, ServerTransaction serverTransactionId) {
        block6: {
            SipProvider provider = (SipProvider)requestEvent.getSource();
            Request notify = requestEvent.getRequest();
            if (notify.getMethod().equals("NOTIFY")) {
                try {
                    logger.info((Object)("referer:  got a NOTIFY count  " + ++this.count + ":\n" + notify));
                    if (serverTransactionId == null) {
                        logger.info((Object)"referer:  null TID.");
                        serverTransactionId = provider.getNewServerTransaction(notify);
                    }
                    Dialog dialog = serverTransactionId.getDialog();
                    logger.info((Object)("Dialog = " + dialog));
                    TestHarness.assertTrue("Dialog should not be null", dialog != null);
                    logger.info((Object)("Dialog State = " + dialog.getState()));
                    Response response = this.messageFactory.createResponse(200, notify);
                    ContactHeader contact = (ContactHeader)this.contactHeader.clone();
                    ((SipURI)contact.getAddress().getURI()).setParameter("id", "sub");
                    response.addHeader((Header)contact);
                    logger.info((Object)("Transaction State = " + serverTransactionId.getState()));
                    serverTransactionId.sendResponse(response);
                    logger.info((Object)("Dialog State = " + dialog.getState()));
                    SubscriptionStateHeader subscriptionState = (SubscriptionStateHeader)notify.getHeader("Subscription-State");
                    String state = subscriptionState.getState();
                    if (state.equalsIgnoreCase("terminated")) {
                        dialog.delete();
                        break block6;
                    }
                    logger.info((Object)("Referer: state now " + state));
                }
                catch (Exception ex) {
                    TestHarness.fail("Failed processing notify, because of " + ex);
                }
            } else {
                TestHarness.fail("Unexpected request type");
            }
        }
    }

    private void processInvite(RequestEvent re) {
        SipProvider provider = (SipProvider)re.getSource();
        ServerTransaction st = re.getServerTransaction();
        try {
            if (st == null) {
                st = provider.getNewServerTransaction(re.getRequest());
            }
            Response r = this.messageFactory.createResponse(100, re.getRequest());
            st.sendResponse(r);
            r = this.messageFactory.createResponse(180, re.getRequest());
            r.addHeader((Header)((ContactHeader)this.contactHeader.clone()));
            ((ToHeader)r.getHeader("To")).setTag("inv_res");
            st.sendResponse(r);
            Thread.sleep(500L);
            r = this.messageFactory.createResponse(200, re.getRequest());
            r.addHeader((Header)((ContactHeader)this.contactHeader.clone()));
            ((ToHeader)r.getHeader("To")).setTag("inv_res");
            st.sendResponse(r);
        }
        catch (Throwable t) {
            t.printStackTrace();
            TestHarness.fail("Throwable:" + t.getLocalizedMessage());
        }
    }

    private void processAck(RequestEvent re) {
    }

    private void processBye(RequestEvent re) {
        try {
            re.getServerTransaction().sendResponse(this.messageFactory.createResponse(200, re.getRequest()));
        }
        catch (Throwable t) {
            t.printStackTrace();
            TestHarness.fail("Throwable:" + t.getLocalizedMessage());
        }
    }

    public void processResponse(ResponseEvent responseReceivedEvent) {
        Response response = responseReceivedEvent.getResponse();
        ClientTransaction tid = responseReceivedEvent.getClientTransaction();
        logger.info((Object)("Got a response:" + response.getStatusCode() + ':' + response.getHeader("CSeq")));
        logger.info((Object)("Response received with client transaction id " + tid + ": " + response.getStatusCode()));
        if (tid == null) {
            logger.info((Object)"Stray response -- dropping ");
            return;
        }
        logger.info((Object)("transaction state is " + tid.getState()));
        logger.info((Object)("Dialog = " + tid.getDialog()));
        if (tid.getDialog() != null) {
            logger.info((Object)("Dialog State is " + tid.getDialog().getState()));
        }
    }

    public SipProvider createProvider() throws Exception {
        this.listeningPoint = this.sipStack.createListeningPoint("127.0.0.1", 5080, this.transport);
        this.sipProvider = this.sipStack.createSipProvider(this.listeningPoint);
        return this.sipProvider;
    }

    public void sendRefer() {
        try {
            String fromName = "BigGuy";
            String fromSipAddress = "here.com";
            String fromDisplayName = "The Master Blaster";
            String toSipAddress = "127.0.0.1";
            String toUser = "referee";
            String toDisplayName = "Referee";
            SipURI fromAddress = this.addressFactory.createSipURI(fromName, fromSipAddress);
            Address fromNameAddress = this.addressFactory.createAddress((URI)fromAddress);
            fromNameAddress.setDisplayName(fromDisplayName);
            FromHeader fromHeader = this.headerFactory.createFromHeader(fromNameAddress, "12345");
            SipURI toAddress = this.addressFactory.createSipURI(toUser, toSipAddress);
            Address toNameAddress = this.addressFactory.createAddress((URI)toAddress);
            toNameAddress.setDisplayName(toDisplayName);
            ToHeader toHeader = this.headerFactory.createToHeader(toNameAddress, null);
            SipURI requestURI = this.addressFactory.createSipURI(toUser, toSipAddress);
            requestURI.setPort(5070);
            requestURI.setTransportParam(this.transport);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            int port = this.sipProvider.getListeningPoint(this.transport).getPort();
            ViaHeader viaHeader = this.headerFactory.createViaHeader("127.0.0.1", port, this.transport, null);
            viaHeaders.add(viaHeader);
            CallIdHeader callIdHeader = this.sipProvider.getNewCallId();
            callIdHeader = this.headerFactory.createCallIdHeader(callIdHeader.getCallId());
            CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(1L, "REFER");
            MaxForwardsHeader maxForwards = this.headerFactory.createMaxForwardsHeader(70);
            Request request = this.messageFactory.createRequest((URI)requestURI, "REFER", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
            String host = this.listeningPoint.getIPAddress();
            SipURI contactUrl = this.addressFactory.createSipURI(fromName, host);
            contactUrl.setPort(this.listeningPoint.getPort());
            SipURI contactURI = this.addressFactory.createSipURI(fromName, host);
            contactURI.setTransportParam(this.transport);
            contactURI.setPort(this.sipProvider.getListeningPoint(this.transport).getPort());
            Address contactAddress = this.addressFactory.createAddress((URI)contactURI);
            contactAddress.setDisplayName(fromName);
            this.contactHeader = this.headerFactory.createContactHeader(contactAddress);
            request.addHeader((Header)this.contactHeader);
            this.subscribeTid = this.sipProvider.getNewClientTransaction(request);
            ReferToHeader referTo = this.headerFactory.createReferToHeader(this.addressFactory.createAddress("<sip:127.0.0.1:5080;transport=" + this.transport + ">"));
            request.addHeader((Header)referTo);
            logger.info((Object)("Refer Dialog = " + this.subscribeTid.getDialog()));
            this.subscribeTid.sendRequest();
        }
        catch (Throwable ex) {
            TestHarness.fail("Referrer failed sending Subscribe request, because of " + ex);
        }
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.info((Object)"io exception event received");
        TestHarness.fail("IOException unexpected");
    }

    public void processTransactionTerminated(TransactionTerminatedEvent tte) {
        logger.info((Object)("transaction terminated:" + tte));
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        logger.info((Object)"dialog terminated event received");
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        logger.info((Object)"Transaction Time out");
    }

    static {
        try {
            logger.setLevel(Level.INFO);
            logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), "logs/refereroutputlog.txt"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

