/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.reinvite;

import java.util.EventObject;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import org.apache.log4j.Logger;
import test.tck.msgflow.callflows.ScenarioHarness;
import test.tck.msgflow.callflows.reinvite.Shootist;
import test.tck.msgflow.callflows.reinvite.Shootme;

public class ReInviteTest
extends ScenarioHarness
implements SipListener {
    protected Shootist shootist;
    private Shootme shootme;
    private static Logger logger = Logger.getLogger((String)"test.tck");

    private SipListener getSipListener(EventObject sipEvent) {
        SipProvider source = (SipProvider)sipEvent.getSource();
        SipListener listener = (SipListener)this.providerTable.get(source);
        ReInviteTest.assertTrue(listener != null);
        return listener;
    }

    public ReInviteTest() {
        super("reinvitetest", true);
    }

    public void setUp() {
        try {
            this.transport = "udp";
            super.setUp();
            this.shootist = new Shootist(this.getRiProtocolObjects());
            SipProvider shootistProvider = this.shootist.createSipProvider();
            this.providerTable.put(shootistProvider, this.shootist);
            this.shootme = new Shootme(this.getTiProtocolObjects());
            SipProvider shootmeProvider = this.shootme.createSipProvider();
            this.providerTable.put(shootmeProvider, this.shootme);
            shootistProvider.addSipListener((SipListener)this);
            shootmeProvider.addSipListener((SipListener)this);
            this.getRiProtocolObjects().start();
            if (this.getTiProtocolObjects() != this.getRiProtocolObjects()) {
                this.getTiProtocolObjects().start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReInviteTest.fail("unexpected exception ");
        }
    }

    public void testSendInvite() {
        this.shootist.sendInvite();
    }

    public void tearDown() {
        try {
            Thread.sleep(8000L);
            this.shootist.checkState();
            this.shootme.checkState();
            super.tearDown();
            Thread.sleep(1000L);
            this.providerTable.clear();
            this.logTestCompleted();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void processRequest(RequestEvent requestEvent) {
        this.getSipListener((EventObject)requestEvent).processRequest(requestEvent);
    }

    public void processResponse(ResponseEvent responseEvent) {
        this.getSipListener((EventObject)responseEvent).processResponse(responseEvent);
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        this.getSipListener((EventObject)timeoutEvent).processTimeout(timeoutEvent);
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        ReInviteTest.fail("unexpected exception");
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        this.getSipListener((EventObject)transactionTerminatedEvent).processTransactionTerminated(transactionTerminatedEvent);
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        this.getSipListener((EventObject)dialogTerminatedEvent).processDialogTerminated(dialogTerminatedEvent);
    }

    static {
        if (!logger.isAttached(console)) {
            logger.addAppender(console);
        }
    }
}

