/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.router;

import javax.sip.SipListener;
import javax.sip.SipProvider;
import org.apache.log4j.Logger;
import test.tck.msgflow.callflows.NonSipUriRouter;
import test.tck.msgflow.callflows.ScenarioHarness;
import test.tck.msgflow.callflows.router.Shootist;
import test.tck.msgflow.callflows.router.Shootme;

public abstract class AbstractRouterTestCase
extends ScenarioHarness
implements SipListener {
    protected Shootist shootist;
    protected Shootme shootme;
    private static Logger logger = Logger.getLogger((String)"test.tck");

    public AbstractRouterTestCase() {
        super("routeteluri", true);
    }

    public void setUp() throws Exception {
        try {
            super.setUp();
            logger.info((Object)"RouterTest: setup()");
            this.shootist = new Shootist(this.getTiProtocolObjects());
            SipProvider shootistProvider = this.shootist.createProvider();
            this.providerTable.put(shootistProvider, this.shootist);
            this.shootme = new Shootme(this.getRiProtocolObjects());
            SipProvider shootmeProvider = this.shootme.createProvider();
            this.providerTable.put(shootmeProvider, this.shootme);
            shootistProvider.addSipListener((SipListener)this);
            shootmeProvider.addSipListener((SipListener)this);
            if (this.getTiProtocolObjects() != this.getRiProtocolObjects()) {
                this.getTiProtocolObjects().start();
            }
            this.getRiProtocolObjects().start();
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected excecption ", (Throwable)ex);
            AbstractRouterTestCase.fail("unexpected exception");
        }
    }

    public void tearDown() throws Exception {
        try {
            Thread.sleep(2000L);
            this.shootist.checkState();
            this.shootme.checkState();
            AbstractRouterTestCase.assertTrue("Router was not consulted", NonSipUriRouter.routerWasConsulted);
            NonSipUriRouter.routerWasConsulted = false;
            super.tearDown();
            Thread.sleep(1000L);
            this.providerTable.clear();
            this.logTestCompleted();
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected exception", (Throwable)ex);
            AbstractRouterTestCase.fail("unexpected exception ");
        }
        super.tearDown();
    }

    static {
        if (!logger.isAttached(console)) {
            logger.addAppender(console);
        }
    }
}

