/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.router;

import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;
import test.tck.msgflow.callflows.router.AbstractRouterTestCase;

public class Shootme
implements SipListener {
    private static SipProvider sipProvider;
    private static AddressFactory addressFactory;
    private static MessageFactory messageFactory;
    private static HeaderFactory headerFactory;
    private static SipStack sipStack;
    private static final String myAddress = "127.0.0.1";
    protected ServerTransaction inviteTid;
    private Dialog dialog;
    private String toTag;
    private String transport;
    private boolean inviteReceived;
    public static final int myPort = 5080;
    private static Logger logger;

    public Shootme(ProtocolObjects protObjects) {
        addressFactory = protObjects.addressFactory;
        messageFactory = protObjects.messageFactory;
        headerFactory = protObjects.headerFactory;
        sipStack = protObjects.sipStack;
        this.transport = protObjects.transport;
    }

    public void processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        ServerTransaction serverTransactionId = requestEvent.getServerTransaction();
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + sipStack.getStackName() + " with server transaction id " + serverTransactionId));
        if (request.getMethod().equals("INVITE")) {
            this.processInvite(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("ACK")) {
            this.processAck(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("BYE")) {
            this.processBye(requestEvent, serverTransactionId);
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
    }

    public void processAck(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        try {
            logger.info((Object)"shootme: got an ACK! Sending  a BYE");
            logger.info((Object)("Dialog State = " + this.dialog.getState()));
            Dialog dialog = serverTransaction.getDialog();
            AbstractRouterTestCase.assertTrue("Dialog mismatch", dialog == this.dialog);
            SipProvider provider = (SipProvider)requestEvent.getSource();
            AbstractRouterTestCase.assertTrue("Provider mismatch", sipProvider == provider);
            Request byeRequest = dialog.createRequest("BYE");
            ClientTransaction ct = provider.getNewClientTransaction(byeRequest);
            dialog.sendRequest(ct);
        }
        catch (Exception ex) {
            TestHarness.fail(ex.getMessage());
        }
    }

    public void processInvite(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        this.inviteReceived = true;
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        try {
            logger.info((Object)"shootme: got an Invite sending Trying");
            Response response = messageFactory.createResponse(100, request);
            ServerTransaction st = requestEvent.getServerTransaction();
            if (st == null) {
                st = sipProvider.getNewServerTransaction(request);
            }
            this.dialog = st.getDialog();
            st.sendResponse(response);
            Response okResponse = messageFactory.createResponse(200, request);
            ToHeader toHeader = (ToHeader)okResponse.getHeader("To");
            this.toTag = "4321";
            toHeader.setTag(this.toTag);
            this.inviteTid = st;
            Address address = addressFactory.createAddress("Shootme <sip:127.0.0.1:5080>");
            ContactHeader contactHeader = headerFactory.createContactHeader(address);
            okResponse.addHeader((Header)contactHeader);
            logger.info((Object)"sending response.");
            st.sendResponse(okResponse);
        }
        catch (Exception ex) {
            TestHarness.fail(ex.getMessage());
        }
    }

    public void processBye(RequestEvent requestEvent, ServerTransaction serverTransactionId) {
        Request request = requestEvent.getRequest();
        try {
            logger.info((Object)"shootme:  got a bye sending OK.");
            Response response = messageFactory.createResponse(200, request);
            serverTransactionId.sendResponse(response);
            logger.info((Object)("Dialog State is " + serverTransactionId.getDialog().getState()));
        }
        catch (Exception ex) {
            TestHarness.fail(ex.getMessage());
            System.exit(0);
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        Object transaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        logger.info((Object)("state = " + transaction.getState()));
        logger.info((Object)("dialog = " + transaction.getDialog()));
        logger.info((Object)("dialogState = " + transaction.getDialog().getState()));
        logger.info((Object)"Transaction Time out");
    }

    public SipProvider createProvider() throws Exception {
        ListeningPoint lp = sipStack.createListeningPoint(myAddress, 5080, this.transport);
        sipProvider = sipStack.createSipProvider(lp);
        logger.info((Object)(this.transport + " SIP provider " + sipProvider));
        return sipProvider;
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.info((Object)"IOException");
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        logger.info((Object)"Transaction terminated event recieved");
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        logger.info((Object)"Dialog terminated event recieved");
    }

    public void checkState() {
        TestHarness.assertTrue(this.inviteReceived);
    }

    static {
        logger = Logger.getLogger((String)"test.tck");
    }
}

