/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.sctp;

import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.helpers.NullEnumeration;
import test.tck.msgflow.callflows.ProtocolObjects;
import test.tck.msgflow.callflows.sctp.SctpTest;

public class Shootme
implements SipListener {
    private ProtocolObjects protocolObjects;
    public static final String myAddress = "127.0.0.1";
    public static final int myPort = 5070;
    private ServerTransaction inviteTid;
    private static Logger logger = Logger.getLogger(Shootme.class);
    private Dialog dialog;
    private boolean okRecieved;

    public Shootme(ProtocolObjects protocolObjects) {
        this.protocolObjects = protocolObjects;
    }

    public void processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        ServerTransaction serverTransactionId = requestEvent.getServerTransaction();
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + this.protocolObjects.sipStack.getStackName() + " with server transaction id " + serverTransactionId));
        if (request.getMethod().equals("INVITE")) {
            this.processInvite(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("ACK")) {
            this.processAck(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("BYE")) {
            this.processBye(requestEvent, serverTransactionId);
        }
    }

    public void processAck(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        try {
            logger.info((Object)("shootme: got an ACK " + requestEvent.getRequest()));
            int ackCount = ((ApplicationData)this.dialog.getApplicationData()).ackCount++;
            if (ackCount == 1) {
                this.dialog = this.inviteTid.getDialog();
                this.sendReInvite(sipProvider);
            }
        }
        catch (Exception ex) {
            String s = "Unexpected error";
            logger.error((Object)s, (Throwable)ex);
            SctpTest.fail(s);
        }
    }

    public void processInvite(RequestEvent requestEvent, ServerTransaction st) {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        logger.info((Object)("Got an INVITE  " + request));
        try {
            logger.info((Object)"shootme: got an Invite sending OK");
            Response response = this.protocolObjects.messageFactory.createResponse(180, request);
            ToHeader toHeader = (ToHeader)response.getHeader("To");
            toHeader.setTag("4321");
            Address address = this.protocolObjects.addressFactory.createAddress("Shootme <sip:127.0.0.1:5070>");
            ((SipURI)address.getURI()).setTransportParam(this.protocolObjects.transport);
            ContactHeader contactHeader = this.protocolObjects.headerFactory.createContactHeader(address);
            response.addHeader((Header)contactHeader);
            if (st == null) {
                st = sipProvider.getNewServerTransaction(request);
                logger.info((Object)("Server transaction created!" + request));
                logger.info((Object)("Dialog = " + st.getDialog()));
                if (st.getDialog().getApplicationData() == null) {
                    st.getDialog().setApplicationData((Object)new ApplicationData());
                }
            } else {
                logger.info((Object)"This is a RE INVITE ");
                SctpTest.assertSame("Dialog mismatch ", st.getDialog(), this.dialog);
            }
            logger.info((Object)("got a server tranasaction " + st));
            byte[] content = request.getRawContent();
            if (content != null) {
                logger.info((Object)(" content = " + new String(content)));
                ContentTypeHeader contentTypeHeader = this.protocolObjects.headerFactory.createContentTypeHeader("application", "sdp");
                logger.info((Object)("response = " + response));
                response.setContent((Object)content, contentTypeHeader);
            }
            this.dialog = st.getDialog();
            if (this.dialog != null) {
                logger.info((Object)("Dialog " + this.dialog));
                logger.info((Object)("Dialog state " + this.dialog.getState()));
            }
            st.sendResponse(response);
            response = this.protocolObjects.messageFactory.createResponse(200, request);
            toHeader = (ToHeader)response.getHeader("To");
            toHeader.setTag("4321");
            response.addHeader((Header)contactHeader);
            st.sendResponse(response);
            logger.info((Object)("TxState after sendResponse = " + st.getState()));
            this.inviteTid = st;
        }
        catch (Exception ex) {
            String s = "unexpected exception";
            logger.error((Object)s, (Throwable)ex);
            SctpTest.fail(s);
        }
    }

    public void sendReInvite(SipProvider sipProvider) throws Exception {
        Request inviteRequest = this.dialog.createRequest("INVITE");
        ClientTransaction ct = sipProvider.getNewClientTransaction(inviteRequest);
        this.dialog.sendRequest(ct);
    }

    public void processBye(RequestEvent requestEvent, ServerTransaction serverTransactionId) {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        try {
            logger.info((Object)"shootme:  got a bye sending OK.");
            Response response = this.protocolObjects.messageFactory.createResponse(200, request);
            if (serverTransactionId != null) {
                serverTransactionId.sendResponse(response);
                logger.info((Object)("Dialog State is " + serverTransactionId.getDialog().getState()));
            } else {
                logger.info((Object)"null server tx.");
            }
        }
        catch (Exception ex) {
            String s = "Unexpected exception";
            logger.error((Object)s, (Throwable)ex);
            SctpTest.fail(s);
        }
    }

    public void processResponse(ResponseEvent responseReceivedEvent) {
        logger.info((Object)"Got a response");
        Response response = responseReceivedEvent.getResponse();
        ClientTransaction tid = responseReceivedEvent.getClientTransaction();
        logger.info((Object)("Response received with client transaction id " + tid + ":\n" + response));
        try {
            Dialog dialog;
            if (response.getStatusCode() == 200 && ((CSeqHeader)response.getHeader("CSeq")).getMethod().equals("INVITE")) {
                this.okRecieved = true;
                SctpTest.assertNotNull("INVITE 200 response should match a transaction", tid);
                dialog = tid.getDialog();
                CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
                Request request = dialog.createAck(cseq.getSeqNumber());
                dialog.sendAck(request);
            }
            if (tid != null) {
                dialog = tid.getDialog();
                logger.info((Object)("Dalog State = " + dialog.getState()));
            }
        }
        catch (Exception ex) {
            String s = "Unexpected exception";
            logger.error((Object)s, (Throwable)ex);
            SctpTest.fail(s);
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        Object transaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        logger.info((Object)("state = " + transaction.getState()));
        logger.info((Object)("dialog = " + transaction.getDialog()));
        logger.info((Object)("dialogState = " + transaction.getDialog().getState()));
        logger.info((Object)"Transaction Time out");
    }

    public SipProvider createSipProvider() throws Exception {
        ListeningPoint lp = this.protocolObjects.sipStack.createListeningPoint(myAddress, 5070, this.protocolObjects.transport);
        SipProvider sipProvider = this.protocolObjects.sipStack.createSipProvider(lp);
        return sipProvider;
    }

    public static void main(String[] args) throws Exception {
        logger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        ProtocolObjects protocolObjects = new ProtocolObjects("shootme", "gov.nist", "udp", true, false);
        Shootme shootme = new Shootme(protocolObjects);
        shootme.createSipProvider().addSipListener((SipListener)shootme);
    }

    public void checkState() {
        ApplicationData data = (ApplicationData)this.dialog.getApplicationData();
        SctpTest.assertTrue(data.ackCount == 1);
        SctpTest.assertTrue(this.okRecieved);
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.error((Object)("An IO Exception was detected : " + exceptionEvent.getHost()));
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        logger.info((Object)"Tx terminated event ");
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        logger.info((Object)"Dialog terminated event detected ");
    }

    static {
        if (logger.getAllAppenders().equals(NullEnumeration.getInstance())) {
            logger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        }
    }

    class ApplicationData {
        protected int ackCount;

        ApplicationData() {
        }
    }
}

