/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.subsnotify;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.sip.ClientTransaction;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import test.tck.msgflow.callflows.ProtocolObjects;
import test.tck.msgflow.callflows.subsnotify.AbstractSubsnotifyTestCase;

public class Forker
implements SipListener {
    private static AddressFactory addressFactory;
    private static MessageFactory messageFactory;
    private static HeaderFactory headerFactory;
    private static SipStack sipStack;
    private SipProvider sipProvider;
    private Hashtable<String, ServerTransaction> serverTransactionTable = new Hashtable();
    private static boolean nonRFC3261Proxy;
    private static Logger logger;
    private final Map CTtoST = new HashMap();
    private String transport;
    private int port;

    private void recordRoute(Message m, String uniqueId) throws ParseException, SipException {
        Address me = addressFactory.createAddress("<sip:127.0.0.1:" + this.port + ";id=" + uniqueId + '>');
        if (!nonRFC3261Proxy) {
            ((SipURI)me.getURI()).setLrParam();
        }
        RecordRouteHeader rr = headerFactory.createRecordRouteHeader(me);
        m.addFirst((Header)rr);
    }

    public void processRequest(RequestEvent re) {
        Request request = re.getRequest();
        ServerTransaction st = re.getServerTransaction();
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + sipStack.getStackName() + " with server transaction id " + st));
        try {
            if (request.getMethod().equals("SUBSCRIBE")) {
                this.processSubscribe(re, st);
            } else if (request.getMethod().equals("NOTIFY")) {
                logger.info((Object)"Got NOTIFY, forwarding statelessly...");
                Request newRequest = (Request)request.clone();
                FromHeader from = (FromHeader)newRequest.getHeader("From");
                this.recordRoute((Message)newRequest, from.getTag());
                if (st != null) {
                    this.serverTransactionTable.put(((ViaHeader)request.getHeader("Via")).getBranch(), st);
                }
                this.doForwardStateless(newRequest, st);
            } else {
                Response notImplemented = messageFactory.createResponse(501, request);
                ((SipProvider)re.getSource()).sendResponse(notImplemented);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processSubscribe(RequestEvent re, ServerTransaction st) {
        Request request = re.getRequest();
        try {
            logger.info((Object)"forker: got an Subscribe -> forking or forwarding");
            ToHeader to = (ToHeader)request.getHeader("To");
            if (to.getTag() == null) {
                logger.info((Object)"forker: got a dialog-creating Subscribe forking twice");
                if (st == null) {
                    st = ((SipProvider)re.getSource()).getNewServerTransaction(request);
                }
                AbstractSubsnotifyTestCase.assertTrue("Proxy: dialog stateless operation expected", st.getDialog() == null);
                Request newRequest = (Request)request.clone();
                newRequest.removeFirst("Route");
                this.doFork(newRequest, st, 5070);
                this.doFork(newRequest, st, 5071);
            } else {
                logger.info((Object)"forker: got a mid-dialog Subscribe, forwarding statelessly...");
                Request newRequest = (Request)request.clone();
                this.doForwardStateless(newRequest, st);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"unexpected exception", (Throwable)ex);
            AbstractSubsnotifyTestCase.fail("unexpected exception");
        }
    }

    public Forker(ProtocolObjects protObjects) {
        addressFactory = protObjects.addressFactory;
        messageFactory = protObjects.messageFactory;
        headerFactory = protObjects.headerFactory;
        sipStack = protObjects.sipStack;
        this.transport = protObjects.transport;
    }

    private void doFork(Request orig, ServerTransaction st, int port) throws Exception {
        ViaHeader myVia = headerFactory.createViaHeader("127.0.0.1", this.sipProvider.getListeningPoint("udp").getPort(), "udp", null);
        Request forked = (Request)orig.clone();
        forked.addHeader((Header)myVia);
        if (nonRFC3261Proxy) {
            SipURI suri = addressFactory.createSipURI(null, "127.0.0.1");
            suri.setPort(port);
            forked.setRequestURI((URI)suri);
        } else {
            RouteHeader route = headerFactory.createRouteHeader(addressFactory.createAddress("<sip:127.0.0.1;lr>"));
            ((SipURI)route.getAddress().getURI()).setPort(port);
            forked.addHeader((Header)route);
        }
        this.recordRoute((Message)forked, Integer.toString(port));
        ClientTransaction ct = this.sipProvider.getNewClientTransaction(forked);
        AbstractSubsnotifyTestCase.assertTrue("Stateless operation -- should not create a dialog ", ct.getDialog() == null);
        this.CTtoST.put(ct, st);
        ct.sendRequest();
    }

    private void doForwardStateless(Request orig, ServerTransaction st) throws ParseException, InvalidArgumentException, SipException {
        ViaHeader top = (ViaHeader)orig.getHeader("Via");
        ViaHeader myVia = headerFactory.createViaHeader("127.0.0.1", this.port, "udp", top.getBranch());
        orig.addFirst((Header)myVia);
        if (nonRFC3261Proxy) {
            RouteHeader route = (RouteHeader)orig.getHeader("Route");
            if (route != null) {
                orig.removeFirst("Route");
                orig.setRequestURI(route.getAddress().getURI());
            }
        } else {
            orig.removeFirst("Route");
        }
        if (st != null) {
            logger.info((Object)"Would like to forward statelessly, but ST!=null! Problem...");
            logger.info((Object)("st == " + st));
        }
        this.sipProvider.sendRequest(orig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(ResponseEvent responseReceivedEvent) {
        block16: {
            logger.info((Object)"Got a response");
            Response response = (Response)responseReceivedEvent.getResponse().clone();
            ClientTransaction ct = responseReceivedEvent.getClientTransaction();
            logger.info((Object)("Dialog = " + responseReceivedEvent.getDialog()));
            logger.info((Object)("Response received with client transaction id " + ct + ": " + response.getStatusCode()));
            if (ct == null) {
                logger.info((Object)"Assuming NOTIFY response, forwarding...");
                response.removeFirst("Via");
                try {
                    String branchId = ((ViaHeader)response.getHeader("Via")).getBranch();
                    ServerTransaction st = this.serverTransactionTable.get(branchId);
                    if (st != null) {
                        st.sendResponse(response);
                        this.serverTransactionTable.remove(branchId);
                        break block16;
                    }
                    this.sipProvider.sendResponse(response);
                }
                catch (SipException e) {
                    AbstractSubsnotifyTestCase.fail("Unexpected exception seen", (Exception)((Object)e));
                }
                catch (InvalidArgumentException ex) {
                    AbstractSubsnotifyTestCase.fail("Unexpected exception seen", (Exception)((Object)ex));
                }
            } else {
                ServerTransaction st = (ServerTransaction)this.CTtoST.get(ct);
                if (st != null) {
                    ServerTransaction serverTransaction = st;
                    synchronized (serverTransaction) {
                        if (st.getState() == TransactionState.TRYING) {
                            response.removeFirst("Via");
                            try {
                                st.sendResponse(response);
                            }
                            catch (SipException e) {
                                e.printStackTrace();
                            }
                            catch (InvalidArgumentException e) {
                                e.printStackTrace();
                            }
                        } else {
                            logger.info((Object)"Discarding second response");
                        }
                        this.CTtoST.remove(ct);
                    }
                } else {
                    logger.info((Object)"No ST found");
                }
            }
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        Object transaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        logger.info((Object)("state = " + transaction.getState()));
        logger.info((Object)"Transaction Time out");
    }

    public SipProvider createProvider(int newPort) {
        try {
            this.port = newPort;
            ListeningPoint lp = sipStack.createListeningPoint("127.0.0.1", this.port, this.transport);
            this.sipProvider = sipStack.createSipProvider(lp);
            this.sipProvider.setAutomaticDialogSupportEnabled(false);
            logger.info((Object)("sip provider " + this.sipProvider));
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            ex.printStackTrace();
            this.sipProvider = null;
        }
        return this.sipProvider;
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
    }

    static {
        logger = Logger.getLogger(Forker.class);
        try {
            logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), "logs/forkeroutputlog.txt"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

