/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.subsnotify;

import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.header.ContactHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;
import test.tck.msgflow.callflows.subsnotify.AbstractSubsnotifyTestCase;

public class Notifier
implements SipListener {
    private static AddressFactory addressFactory;
    private static MessageFactory messageFactory;
    private static HeaderFactory headerFactory;
    private static SipStack sipStack;
    private int port;
    protected SipProvider sipProvider;
    protected Dialog dialog;
    private String transport;
    private static Logger logger;
    private boolean gotSubscribeRequest;

    public void processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        ServerTransaction serverTransactionId = requestEvent.getServerTransaction();
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + sipStack.getStackName() + " with server transaction id " + serverTransactionId + " and dialog id " + requestEvent.getDialog()));
        if (request.getMethod().equals("SUBSCRIBE")) {
            this.processSubscribe(requestEvent, serverTransactionId);
        }
    }

    public void processSubscribe(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        try {
            boolean isInitial;
            logger.info((Object)"notifier: got an Subscribe sending OK");
            logger.info((Object)("notifier:  " + request));
            logger.info((Object)("notifier : dialog = " + requestEvent.getDialog()));
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            this.gotSubscribeRequest = true;
            AbstractSubsnotifyTestCase.assertTrue("Event header is null ", eventHeader != null);
            Response response = null;
            ServerTransaction st = requestEvent.getServerTransaction();
            if (st == null) {
                st = sipProvider.getNewServerTransaction(request);
            }
            boolean bl = isInitial = requestEvent.getDialog() == null;
            if (isInitial) {
                String toTag = Integer.toHexString((int)(Math.random() * 2.147483647E9));
                response = messageFactory.createResponse(202, request);
                ToHeader toHeader = (ToHeader)response.getHeader("To");
                AbstractSubsnotifyTestCase.assertTrue("To tag should  be null ", toHeader.getTag() == null);
                toHeader.setTag(toTag);
                this.dialog = st.getDialog();
                this.dialog.terminateOnBye(false);
                AbstractSubsnotifyTestCase.assertTrue("initial -- dialog assigned to the transaction not null ", this.dialog != null);
                AbstractSubsnotifyTestCase.assertTrue("Dialog state should be null ", this.dialog.getState() == null);
            } else {
                response = messageFactory.createResponse(200, request);
            }
            Address address = addressFactory.createAddress("Notifier <sip:127.0.0.1>");
            ((SipURI)address.getURI()).setPort(sipProvider.getListeningPoint(this.transport).getPort());
            ContactHeader contactHeader = headerFactory.createContactHeader(address);
            response.addHeader((Header)contactHeader);
            ExpiresHeader expires = (ExpiresHeader)request.getHeader("Expires");
            if (expires == null) {
                expires = headerFactory.createExpiresHeader(30);
            }
            response.addHeader((Header)expires);
            st.sendResponse(response);
            Request notifyRequest = this.dialog.createRequest("NOTIFY");
            ((SipURI)contactHeader.getAddress().getURI()).setParameter("id", "not");
            SubscriptionStateHeader sstate = headerFactory.createSubscriptionStateHeader(isInitial ? "pending" : "terminated");
            if (sstate.getState().equalsIgnoreCase("terminated")) {
                sstate.setReasonCode("deactivated");
            }
            notifyRequest.addHeader((Header)sstate);
            notifyRequest.setHeader((Header)eventHeader);
            notifyRequest.setHeader((Header)contactHeader);
            ClientTransaction ct = sipProvider.getNewClientTransaction(notifyRequest);
            this.dialog.sendRequest(ct);
            logger.info((Object)("NOTIFY Branch ID " + ((ViaHeader)request.getHeader("Via")).getParameter("branch")));
            logger.info((Object)("Dialog " + this.dialog));
            logger.info((Object)("Dialog state after pending NOTIFY: " + this.dialog.getState()));
            AbstractSubsnotifyTestCase.assertTrue("Dialog state after pending NOTIFY ", this.dialog.getState() == DialogState.CONFIRMED);
            if (isInitial) {
                Thread myEventSource = new Thread(new MyEventSource(this, eventHeader));
                myEventSource.start();
            }
        }
        catch (Throwable ex) {
            logger.info((Object)ex.getMessage(), ex);
            TestHarness.fail("Failed to processs Subscriber, because of " + ex.getMessage());
        }
    }

    public void processResponse(ResponseEvent responseReceivedEvent) {
        Response response = responseReceivedEvent.getResponse();
        ClientTransaction tid = responseReceivedEvent.getClientTransaction();
        logger.info((Object)("Response received with client transaction id " + tid + " CSeq = " + response.getHeader("CSeq") + " status code = " + response.getStatusCode()));
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        Object transaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        logger.info((Object)("state = " + transaction.getState()));
        logger.info((Object)("dialog = " + transaction.getDialog()));
        logger.info((Object)("dialogState = " + transaction.getDialog().getState()));
        logger.info((Object)"Transaction Time out");
        AbstractSubsnotifyTestCase.fail("Unexpected timeout event");
    }

    public SipProvider createProvider(int newPort) {
        try {
            this.port = newPort;
            ListeningPoint lp = sipStack.createListeningPoint("127.0.0.1", this.port, this.transport);
            this.sipProvider = sipStack.createSipProvider(lp);
            logger.info((Object)("udp provider " + this.sipProvider));
        }
        catch (Exception ex) {
            logger.info((Object)ex.getMessage(), (Throwable)ex);
            this.sipProvider = null;
            TestHarness.fail("Failed to create SIP Provider on port " + newPort + ", because of " + ex.getMessage());
        }
        return this.sipProvider;
    }

    public Notifier(ProtocolObjects protObjects) {
        addressFactory = protObjects.addressFactory;
        messageFactory = protObjects.messageFactory;
        headerFactory = protObjects.headerFactory;
        sipStack = protObjects.sipStack;
        this.transport = protObjects.transport;
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
    }

    public void checkState() {
        TestHarness.assertTrue("Did not see subscribe", this.gotSubscribeRequest);
    }

    static {
        logger = Logger.getLogger(Notifier.class);
        try {
            logger.setLevel(Level.INFO);
            logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), "logs/notifieroutputlog.txt"));
        }
        catch (Exception ex) {
            logger.info((Object)ex.getMessage(), (Throwable)ex);
            TestHarness.fail("Failed to initialize Subscriber, because of " + ex.getMessage());
        }
    }

    class MyEventSource
    implements Runnable {
        private Notifier notifier;
        private EventHeader eventHeader;

        public MyEventSource(Notifier notifier2, EventHeader eventHeader) {
            this.notifier = notifier2;
            this.eventHeader = eventHeader;
        }

        public void run() {
            try {
                for (int i = 0; i < 1; ++i) {
                    Thread.sleep(1000L);
                    Request request = this.notifier.dialog.createRequest("NOTIFY");
                    SubscriptionStateHeader subscriptionState = headerFactory.createSubscriptionStateHeader("active");
                    request.addHeader((Header)subscriptionState);
                    request.addHeader((Header)this.eventHeader);
                    ((SipURI)Notifier.this.dialog.getLocalParty().getURI()).setParameter("id", "not2");
                    ClientTransaction ct = Notifier.this.sipProvider.getNewClientTransaction(request);
                    logger.info((Object)("NOTIFY Branch ID " + ((ViaHeader)request.getHeader("Via")).getParameter("branch")));
                    this.notifier.dialog.sendRequest(ct);
                    logger.info((Object)("Dialog " + Notifier.this.dialog));
                    logger.info((Object)("Dialog state after active NOTIFY: " + Notifier.this.dialog.getState()));
                }
            }
            catch (Throwable ex) {
                logger.info((Object)ex.getMessage(), ex);
                TestHarness.fail("Failed MyEventSource.run(), because of " + ex.getMessage());
            }
        }
    }
}

