/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.subsnotify;

import java.util.ArrayList;
import java.util.HashSet;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import test.tck.TestHarness;
import test.tck.msgflow.callflows.ProtocolObjects;
import test.tck.msgflow.callflows.subsnotify.AbstractSubsnotifyTestCase;

public class Subscriber
implements SipListener {
    private SipProvider sipProvider;
    private static AddressFactory addressFactory;
    private static MessageFactory messageFactory;
    private static HeaderFactory headerFactory;
    private static SipStack sipStack;
    private ContactHeader contactHeader;
    private static String transport;
    private int count;
    private HashSet dialogs;
    private static Logger logger;
    private ClientTransaction subscribeTid;
    private ListeningPoint listeningPoint;
    private int port;
    private Dialog subscriberDialog;
    private Dialog forkedDialog;

    public Subscriber(ProtocolObjects protObjects) {
        addressFactory = protObjects.addressFactory;
        messageFactory = protObjects.messageFactory;
        headerFactory = protObjects.headerFactory;
        sipStack = protObjects.sipStack;
        transport = protObjects.transport;
        this.dialogs = new HashSet();
    }

    public void processRequest(RequestEvent requestReceivedEvent) {
        Request request = requestReceivedEvent.getRequest();
        ServerTransaction serverTransactionId = requestReceivedEvent.getServerTransaction();
        String viaBranch = ((ViaHeader)request.getHeaders("Via").next()).getParameter("branch");
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + sipStack.getStackName() + " with server transaction id " + serverTransactionId + " branch ID = " + viaBranch));
        if (request.getMethod().equals("NOTIFY")) {
            this.processNotify(requestReceivedEvent, serverTransactionId);
        }
    }

    public void processNotify(RequestEvent requestEvent, ServerTransaction serverTransactionId) {
        SipProvider provider = (SipProvider)requestEvent.getSource();
        AbstractSubsnotifyTestCase.assertTrue("provider must be the same as my provider ", provider == this.sipProvider);
        Request notify = requestEvent.getRequest();
        try {
            logger.info((Object)("subscriber:  got a notify count  " + this.count++));
            if (serverTransactionId == null) {
                logger.info((Object)"subscriber:  null TID.");
                serverTransactionId = provider.getNewServerTransaction(notify);
            }
            Dialog dialog = serverTransactionId.getDialog();
            AbstractSubsnotifyTestCase.assertTrue("subscriberDialog", this.subscriberDialog != null);
            AbstractSubsnotifyTestCase.assertTrue("Dialog should not be null", dialog != null);
            if (dialog != this.subscriberDialog) {
                if (this.forkedDialog == null) {
                    this.forkedDialog = dialog;
                } else {
                    AbstractSubsnotifyTestCase.assertTrue("Dialog should be either the subscriber dialog ", this.forkedDialog == dialog);
                }
            }
            this.dialogs.add(dialog);
            logger.info((Object)("Dialog State = " + dialog.getState()));
            AbstractSubsnotifyTestCase.assertTrue("Dialog state should be confirmed ", dialog.getState() == DialogState.CONFIRMED);
            Response response = messageFactory.createResponse(200, notify);
            ContactHeader contact = (ContactHeader)this.contactHeader.clone();
            ((SipURI)contact.getAddress().getURI()).setParameter("id", "sub");
            response.addHeader((Header)contact);
            logger.info((Object)("Transaction State = " + serverTransactionId.getState()));
            AbstractSubsnotifyTestCase.assertTrue("transaction state should be trying", serverTransactionId.getState() == TransactionState.TRYING);
            serverTransactionId.sendResponse(response);
            logger.info((Object)("Dialog State = " + dialog.getState()));
            SubscriptionStateHeader subscriptionState = (SubscriptionStateHeader)notify.getHeader("Subscription-State");
            String state = subscriptionState.getState();
            if (state.equalsIgnoreCase("terminated")) {
                dialog.delete();
            } else if (state.equalsIgnoreCase("active")) {
                logger.info((Object)"Subscriber: sending unSUBSCRIBE");
                Request unsubscribe = dialog.createRequest("SUBSCRIBE");
                logger.info((Object)("dialog created:" + unsubscribe));
                ((SipURI)dialog.getLocalParty().getURI()).setParameter("id", "unsub");
                ExpiresHeader expires = headerFactory.createExpiresHeader(0);
                unsubscribe.addHeader((Header)expires);
                unsubscribe.addHeader(notify.getHeader("Event"));
                logger.info((Object)("Sending Unsubscribe : " + unsubscribe));
                logger.info((Object)("unsubscribe dialog  " + dialog));
                ClientTransaction ct = this.sipProvider.getNewClientTransaction(unsubscribe);
                AbstractSubsnotifyTestCase.assertTrue("Dialog mismatch " + ct.getDialog() + " dialog " + dialog, ct.getDialog() == dialog);
                dialog.sendRequest(ct);
            } else {
                logger.info((Object)("Subscriber: state now " + state));
                AbstractSubsnotifyTestCase.assertTrue("State should be pending was " + state, state.equalsIgnoreCase("pending"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected exception", (Throwable)ex);
            TestHarness.fail("Failed to process Notify, because of " + ex.getMessage());
        }
    }

    public void processResponse(ResponseEvent responseReceivedEvent) {
        logger.info((Object)"Got a response");
        Response response = responseReceivedEvent.getResponse();
        ClientTransaction tid = responseReceivedEvent.getClientTransaction();
        logger.info((Object)("Response received with client transaction id " + tid + ":\n" + response.getStatusCode()));
        if (tid == null) {
            logger.warn((Object)"Stray response -- dropping ");
            return;
        }
        logger.info((Object)("transaction state is " + tid.getState()));
        logger.info((Object)("Dialog = " + tid.getDialog()));
        if (tid.getDialog() != null) {
            logger.info((Object)("Dialog State is " + tid.getDialog().getState()));
        }
        if (tid.getDialog() != null) {
            this.dialogs.add(tid.getDialog());
        }
    }

    public SipProvider createProvider(int newPort) {
        try {
            this.port = newPort;
            this.listeningPoint = sipStack.createListeningPoint("127.0.0.1", this.port, transport);
            this.sipProvider = sipStack.createSipProvider(this.listeningPoint);
            this.sipProvider.setAutomaticDialogSupportEnabled(true);
            logger.info((Object)("udp provider " + this.sipProvider));
        }
        catch (Exception ex) {
            logger.info((Object)ex.getMessage(), (Throwable)ex);
            TestHarness.fail("Failed to create SIP Provider on port " + newPort + ", because of " + ex.getMessage());
            this.sipProvider = null;
        }
        return this.sipProvider;
    }

    public void sendSubscribe(int notifierPort) {
        try {
            String fromName = "BigGuy";
            String fromSipAddress = "here.com";
            String fromDisplayName = "The Master Blaster";
            String toSipAddress = "there.com";
            String toUser = "LittleGuy";
            String toDisplayName = "The Little Blister";
            SipURI fromAddress = addressFactory.createSipURI(fromName, fromSipAddress);
            Address fromNameAddress = addressFactory.createAddress((URI)fromAddress);
            fromNameAddress.setDisplayName(fromDisplayName);
            FromHeader fromHeader = headerFactory.createFromHeader(fromNameAddress, "12345");
            SipURI toAddress = addressFactory.createSipURI(toUser, toSipAddress);
            Address toNameAddress = addressFactory.createAddress((URI)toAddress);
            toNameAddress.setDisplayName(toDisplayName);
            ToHeader toHeader = headerFactory.createToHeader(toNameAddress, null);
            SipURI requestURI = addressFactory.createSipURI(toUser, toSipAddress);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            int port = this.sipProvider.getListeningPoint(transport).getPort();
            ViaHeader viaHeader = headerFactory.createViaHeader("127.0.0.1", port, transport, null);
            viaHeaders.add(viaHeader);
            CallIdHeader callIdHeader = this.sipProvider.getNewCallId();
            callIdHeader = headerFactory.createCallIdHeader(callIdHeader.getCallId());
            CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(1L, "SUBSCRIBE");
            MaxForwardsHeader maxForwards = headerFactory.createMaxForwardsHeader(70);
            Request request = messageFactory.createRequest((URI)requestURI, "SUBSCRIBE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
            String host = this.listeningPoint.getIPAddress();
            SipURI contactUrl = addressFactory.createSipURI(fromName, host);
            contactUrl.setPort(this.listeningPoint.getPort());
            SipURI contactURI = addressFactory.createSipURI(fromName, host);
            contactURI.setTransportParam(transport);
            contactURI.setPort(this.sipProvider.getListeningPoint(transport).getPort());
            Address contactAddress = addressFactory.createAddress((URI)contactURI);
            contactAddress.setDisplayName(fromName);
            this.contactHeader = headerFactory.createContactHeader(contactAddress);
            request.addHeader((Header)this.contactHeader);
            RouteHeader route = headerFactory.createRouteHeader(addressFactory.createAddress("<sip:127.0.0.1:" + notifierPort + ";transport=" + transport + ";lr>"));
            request.addHeader((Header)route);
            this.subscribeTid = this.sipProvider.getNewClientTransaction(request);
            EventHeader eventHeader = headerFactory.createEventHeader("foo");
            eventHeader.setEventId("foo");
            request.addHeader((Header)eventHeader);
            logger.info((Object)("Subscribe Dialog = " + this.subscribeTid.getDialog()));
            this.subscriberDialog = this.subscribeTid.getDialog();
            this.dialogs.add(this.subscriberDialog);
            this.subscribeTid.sendRequest();
        }
        catch (Throwable ex) {
            logger.info((Object)ex.getMessage(), ex);
            TestHarness.fail("Failed to send Subscribe to notifier port" + notifierPort + ", because of " + ex.getMessage());
        }
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.info((Object)"io exception event recieved");
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        logger.info((Object)"transaction terminated");
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        logger.info((Object)"dialog terminated event recieved");
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        logger.info((Object)"Transaction Time out");
    }

    public void checkState() {
    }

    static {
        logger = Logger.getLogger(Subscriber.class);
        try {
            logger.setLevel(Level.INFO);
            logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), "logs/subscriberoutputlog.txt"));
        }
        catch (Exception ex) {
            logger.info((Object)ex.getMessage(), (Throwable)ex);
            TestHarness.fail("Failed to initialize Subscriber, because of " + ex.getMessage());
        }
    }
}

