/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow.callflows.tls;

import java.util.ArrayList;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.helpers.NullEnumeration;
import test.tck.msgflow.callflows.ProtocolObjects;
import test.tck.msgflow.callflows.tls.TlsTest;

public class Shootist
implements SipListener {
    private SipProvider provider;
    private int reInviteCount;
    private ContactHeader contactHeader;
    private ListeningPoint listeningPoint;
    private int counter;
    private static String PEER_ADDRESS = "127.0.0.1";
    private static int PEER_PORT = 5070;
    private static String peerHostPort = PEER_ADDRESS + ":" + PEER_PORT;
    public static final String myAddress = "127.0.0.1";
    private static final int myPort = 5060;
    protected ClientTransaction inviteTid;
    private boolean okReceived;
    private boolean byeOkRecieved;
    private boolean byeSent;
    private static Logger logger = Logger.getLogger(Shootist.class);
    private ProtocolObjects protocolObjects;
    private Dialog dialog;

    public Shootist(ProtocolObjects protocolObjects) {
        this.protocolObjects = protocolObjects;
    }

    public void processRequest(RequestEvent requestReceivedEvent) {
        Request request = requestReceivedEvent.getRequest();
        ServerTransaction serverTransactionId = requestReceivedEvent.getServerTransaction();
        logger.info((Object)("\n\nRequest " + request.getMethod() + " received at " + this.protocolObjects.sipStack.getStackName() + " with server transaction id " + serverTransactionId));
        if (request.getMethod().equals("BYE")) {
            this.processBye(request, serverTransactionId);
        } else if (request.getMethod().equals("INVITE")) {
            this.processInvite(request, serverTransactionId);
        } else if (request.getMethod().equals("ACK")) {
            this.processAck(request, serverTransactionId);
        }
    }

    public void processInvite(Request request, ServerTransaction st) {
        try {
            Dialog dialog = st.getDialog();
            Response response = this.protocolObjects.messageFactory.createResponse(200, request);
            ((ToHeader)response.getHeader("To")).setTag(((ToHeader)request.getHeader("To")).getTag());
            Address address = this.protocolObjects.addressFactory.createAddress("Shootme <sips:127.0.0.1:5060>");
            ContactHeader contactHeader = this.protocolObjects.headerFactory.createContactHeader(address);
            response.addHeader((Header)contactHeader);
            st.sendResponse(response);
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected exception", (Throwable)ex);
            TlsTest.fail("unexpected exception");
        }
    }

    public void processAck(Request request, ServerTransaction tid) {
        try {
            logger.info((Object)("Got an ACK! sending bye : " + tid));
            if (tid != null) {
                Dialog dialog = tid.getDialog();
                TlsTest.assertSame("dialog id mismatch", dialog, this.dialog);
                Request bye = dialog.createRequest("BYE");
                MaxForwardsHeader mf = this.protocolObjects.headerFactory.createMaxForwardsHeader(10);
                bye.addHeader((Header)mf);
                ClientTransaction ct = this.provider.getNewClientTransaction(bye);
                dialog.sendRequest(ct);
                this.byeSent = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected exception", (Throwable)ex);
            TlsTest.fail("unexpected exception");
        }
    }

    public void processBye(Request request, ServerTransaction serverTransactionId) {
        try {
            logger.info((Object)"shootist:  got a bye .");
            if (serverTransactionId == null) {
                logger.info((Object)"shootist:  null TID.");
                return;
            }
            Dialog dialog = serverTransactionId.getDialog();
            TlsTest.assertSame("dialog mismatch", dialog, this.dialog);
            logger.info((Object)("Dialog State = " + dialog.getState()));
            Response response = this.protocolObjects.messageFactory.createResponse(200, request);
            serverTransactionId.sendResponse(response);
            logger.info((Object)"shootist:  Sending OK.");
            logger.info((Object)("Dialog State = " + dialog.getState()));
            TlsTest.assertEquals("Should be terminated", dialog.getState(), DialogState.TERMINATED);
        }
        catch (Exception ex) {
            logger.error((Object)"unexpected exception", (Throwable)ex);
            TlsTest.fail("unexpected exception");
        }
    }

    public void processResponse(ResponseEvent responseReceivedEvent) {
        logger.info((Object)"Got a response");
        Response response = responseReceivedEvent.getResponse();
        ClientTransaction tid = responseReceivedEvent.getClientTransaction();
        logger.info((Object)("Response received with client transaction id " + tid + ":\n" + response.getStatusCode()));
        if (tid == null) {
            logger.info((Object)"Stray response -- dropping ");
            return;
        }
        logger.info((Object)("transaction state is " + tid.getState()));
        logger.info((Object)("Dialog = " + tid.getDialog()));
        logger.info((Object)("Dialog State is " + tid.getDialog().getState()));
        SipProvider provider = (SipProvider)responseReceivedEvent.getSource();
        try {
            CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
            if (response.getStatusCode() == 200 && cseq.getMethod().equals("INVITE")) {
                Dialog dialog = tid.getDialog();
                Request ackRequest = dialog.createAck(cseq.getSeqNumber());
                TlsTest.assertTrue("Secure URI", ((SipURI)ackRequest.getRequestURI()).isSecure());
                logger.info((Object)("Ack request to send = " + ackRequest));
                logger.info((Object)"Sending ACK");
                dialog.sendAck(ackRequest);
                if (this.reInviteCount == 0) {
                    Request inviteRequest = dialog.createRequest("INVITE");
                    Thread.sleep(100L);
                    ClientTransaction ct = provider.getNewClientTransaction(inviteRequest);
                    dialog.sendRequest(ct);
                    ++this.reInviteCount;
                } else {
                    this.okReceived = true;
                }
            } else if (response.getStatusCode() == 200 && ((CSeqHeader)response.getHeader("CSeq")).getMethod().equals("BYE")) {
                this.byeOkRecieved = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            TlsTest.fail("unexpected exception");
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        logger.info((Object)"Transaction Time out");
        logger.info((Object)("TimeoutEvent " + timeoutEvent.getTimeout()));
    }

    public SipProvider createSipProvider() {
        try {
            this.listeningPoint = this.protocolObjects.sipStack.createListeningPoint(myAddress, 5060, this.protocolObjects.transport);
            this.provider = this.protocolObjects.sipStack.createSipProvider(this.listeningPoint);
            return this.provider;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            TlsTest.fail("unable to create provider");
            return null;
        }
    }

    public void sendInvite() {
        try {
            String fromName = "BigGuy";
            String fromSipAddress = "here.com";
            String fromDisplayName = "The Master Blaster";
            String toSipAddress = "there.com";
            String toUser = "LittleGuy";
            String toDisplayName = "The Little Blister";
            SipURI fromAddress = this.protocolObjects.addressFactory.createSipURI(fromName, fromSipAddress);
            fromAddress.setSecure(true);
            Address fromNameAddress = this.protocolObjects.addressFactory.createAddress((URI)fromAddress);
            fromNameAddress.setDisplayName(fromDisplayName);
            FromHeader fromHeader = this.protocolObjects.headerFactory.createFromHeader(fromNameAddress, new Integer((int)(Math.random() * 2.147483647E9)).toString());
            SipURI toAddress = this.protocolObjects.addressFactory.createSipURI(toUser, toSipAddress);
            toAddress.setSecure(true);
            Address toNameAddress = this.protocolObjects.addressFactory.createAddress((URI)toAddress);
            toNameAddress.setDisplayName(toDisplayName);
            ToHeader toHeader = this.protocolObjects.headerFactory.createToHeader(toNameAddress, null);
            SipURI requestURI = this.protocolObjects.addressFactory.createSipURI(toUser, peerHostPort);
            requestURI.setSecure(true);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            int port = this.provider.getListeningPoint(this.protocolObjects.transport).getPort();
            ViaHeader viaHeader = this.protocolObjects.headerFactory.createViaHeader(myAddress, port, this.protocolObjects.transport, null);
            viaHeaders.add(viaHeader);
            ContentTypeHeader contentTypeHeader = this.protocolObjects.headerFactory.createContentTypeHeader("application", "sdp");
            CallIdHeader callIdHeader = this.provider.getNewCallId();
            callIdHeader = this.protocolObjects.headerFactory.createCallIdHeader(callIdHeader.getCallId());
            CSeqHeader cSeqHeader = this.protocolObjects.headerFactory.createCSeqHeader(1L, "INVITE");
            MaxForwardsHeader maxForwards = this.protocolObjects.headerFactory.createMaxForwardsHeader(70);
            Request request = this.protocolObjects.messageFactory.createRequest((URI)requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
            SipURI contactURI = this.protocolObjects.addressFactory.createSipURI(fromName, myAddress);
            contactURI.setSecure(true);
            contactURI.setPort(this.provider.getListeningPoint(this.protocolObjects.transport).getPort());
            Address contactAddress = this.protocolObjects.addressFactory.createAddress((URI)contactURI);
            contactAddress.setDisplayName(fromName);
            this.contactHeader = this.protocolObjects.headerFactory.createContactHeader(contactAddress);
            request.addHeader((Header)this.contactHeader);
            Header extensionHeader = this.protocolObjects.headerFactory.createHeader("My-Header", "my header value");
            request.addHeader(extensionHeader);
            String sdpData = "v=0\r\no=4855 13760799956958020 13760799956958020 IN IP4  192.168.1.2\r\ns=mysession session\r\np=+46 8 52018010\r\nc=IN IP4  192.168.1.2\r\nt=0 0\r\nm=audio 6022 RTP/AVP 0 4 18\r\na=rtpmap:0 PCMU/8000\r\na=rtpmap:4 G723/8000\r\na=rtpmap:18 G729A/8000\r\na=ptime:20\r\n";
            request.setContent((Object)sdpData, contentTypeHeader);
            Address address = this.protocolObjects.addressFactory.createAddress("<sips:" + PEER_ADDRESS + ":" + PEER_PORT + ">");
            RouteHeader routeHeader = this.protocolObjects.headerFactory.createRouteHeader(address);
            ((SipURI)address.getURI()).setLrParam();
            request.addHeader((Header)routeHeader);
            extensionHeader = this.protocolObjects.headerFactory.createHeader("My-Other-Header", "my new header value ");
            request.addHeader(extensionHeader);
            Header callInfoHeader = this.protocolObjects.headerFactory.createHeader("Call-Info", "<http://[::1]/test.html>");
            request.addHeader(callInfoHeader);
            this.inviteTid = this.provider.getNewClientTransaction(request);
            this.dialog = this.inviteTid.getDialog();
            TlsTest.assertTrue(this.dialog.getState() == null);
            this.inviteTid.sendRequest();
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected exception", (Throwable)ex);
            TlsTest.fail("unexpected exception");
        }
    }

    public void checkState() {
        TlsTest.assertTrue(this.reInviteCount == 1 && this.okReceived);
        TlsTest.assertTrue(this.byeSent && this.byeOkRecieved);
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        logger.error((Object)"IO Exception!");
        TlsTest.fail("Unexpected exception");
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        logger.info((Object)"Transaction Terminated Event!");
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        logger.info((Object)"Dialog Terminated Event!");
    }

    static {
        if (logger.getAllAppenders().equals(NullEnumeration.getInstance())) {
            logger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        }
    }
}

