/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.imap;

import gnu.mail.providers.imap.IMAPMessage;
import gnu.mail.providers.imap.IMAPMultipart;
import gnu.mail.providers.imap.IMAPMultipartDataSource;
import gnu.mail.providers.imap.IMAPStore;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import org.jpackage.mail.inet.imap.IMAPConnection;
import org.jpackage.mail.inet.imap.IMAPConstants;
import org.jpackage.mail.inet.imap.MessageStatus;
import org.jpackage.mail.inet.imap.Pair;

public class IMAPBodyPart
extends MimeBodyPart
implements IMAPConstants {
    protected IMAPMessage message;
    protected String section;
    protected int size;
    protected int lines;
    IMAPMultipart multipart = null;

    protected IMAPBodyPart(IMAPMessage message, IMAPMultipart parent, String section, InternetHeaders headers, int size, int lines) throws MessagingException {
        super(headers, null);
        this.parent = parent;
        this.message = message;
        this.section = section;
        this.size = size;
        this.lines = lines;
    }

    void fetchContent() throws MessagingException {
        String[] commands = new String[]{"BODY.PEEK[" + this.section + "]"};
        this.fetch(commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetch(String[] commands) throws MessagingException {
        try {
            IMAPConnection connection = ((IMAPStore)this.message.getFolder().getStore()).getConnection();
            int msgnum = this.message.getMessageNumber();
            int[] messages = new int[]{msgnum};
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                MessageStatus[] ms = connection.fetch(messages, commands);
                for (int i = 0; i < ms.length; ++i) {
                    if (ms[i].getMessageNumber() != msgnum) continue;
                    this.update(ms[i]);
                }
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void update(MessageStatus status) throws MessagingException {
        List code = status.getCode();
        int clen = code.size();
        for (int i = 0; i < clen; i += 2) {
            Object item = code.get(i);
            String key = null;
            List params = Collections.EMPTY_LIST;
            if (item instanceof Pair) {
                Pair pair = (Pair)item;
                key = pair.getKey();
                params = pair.getValue();
            } else {
                if (!(item instanceof String)) throw new MessagingException("Unexpected status item: " + item);
                key = (String)item;
            }
            if (key != "BODY") throw new MessagingException("Unknown section status key: " + key);
            int plen = params.size();
            if (plen <= 0) throw new MessagingException("Not a section!");
            Object pitem = params.get(0);
            String pkey = null;
            if (!(pitem instanceof String)) {
                throw new MessagingException("Unexpected status item: " + pitem);
            }
            pkey = (String)pitem;
            if (!pkey.equals(this.section)) {
                throw new MessagingException("Unexpected section number: " + pkey);
            }
            this.content = (byte[])code.get(i + 1);
        }
    }

    public int getSize() throws MessagingException {
        return this.size;
    }

    public int getLineCount() throws MessagingException {
        return this.lines;
    }

    public DataHandler getDataHandler() throws MessagingException {
        ContentType ct = new ContentType(this.getContentType());
        if ("multipart".equalsIgnoreCase(ct.getPrimaryType())) {
            return new DataHandler((DataSource)new IMAPMultipartDataSource(this.multipart));
        }
        if (this.content == null) {
            this.fetchContent();
        }
        return super.getDataHandler();
    }

    public Object getContent() throws MessagingException, IOException {
        ContentType ct = new ContentType(this.getContentType());
        if ("multipart".equalsIgnoreCase(ct.getPrimaryType())) {
            return this.multipart;
        }
        return super.getContent();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.content == null) {
            this.fetchContent();
        }
        return super.getContentStream();
    }
}

