/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.imap;

import gnu.mail.providers.imap.IMAPFolder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.URLName;
import javax.net.ssl.TrustManager;
import org.jpackage.mail.inet.imap.IMAPConnection;
import org.jpackage.mail.inet.imap.Namespaces;
import org.jpackage.mail.inet.imap.Quota;

public class IMAPStore
extends Store {
    protected IMAPConnection connection = null;
    protected IMAPFolder root = null;
    protected IMAPFolder selected = null;

    public IMAPStore(Session session, URLName url) {
        super(session, url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        if (this.connection != null) {
            return true;
        }
        if (host == null) {
            host = this.getProperty("host");
        }
        if (username == null) {
            username = this.getProperty("user");
        }
        if (port < 0) {
            port = this.getIntProperty("port");
        }
        if (host == null || username == null || password == null) {
            return false;
        }
        IMAPStore iMAPStore = this;
        synchronized (iMAPStore) {
            try {
                int connectionTimeout = this.getIntProperty("connectiontimeout");
                int timeout = this.getIntProperty("timeout");
                if (this.session.getDebug()) {
                    IMAPConnection.logger.setLevel(IMAPConnection.IMAP_TRACE);
                }
                boolean tls = "imaps".equals(this.url.getProtocol());
                TrustManager tm = this.getTrustManager();
                this.connection = new IMAPConnection(host, port, connectionTimeout, timeout, tls, tm);
                if (this.propertyIsTrue("debug.ansi")) {
                    this.connection.setAnsiDebug(true);
                }
                List capabilities = this.connection.capability();
                if (!tls && capabilities.contains("STARTTLS") && !this.propertyIsFalse("tls") && (tls = tm == null ? this.connection.starttls() : this.connection.starttls(tm))) {
                    capabilities = this.connection.capability();
                }
                if (!tls && "required".equals(this.getProperty("tls"))) {
                    throw new MessagingException("TLS not available");
                }
                ArrayList<String> authenticationMechanisms = null;
                Iterator i = capabilities.iterator();
                while (i.hasNext()) {
                    String cap = (String)i.next();
                    if (!cap.startsWith("AUTH=")) continue;
                    if (authenticationMechanisms == null) {
                        authenticationMechanisms = new ArrayList<String>();
                    }
                    authenticationMechanisms.add(cap.substring(5));
                }
                if (authenticationMechanisms != null && !authenticationMechanisms.isEmpty()) {
                    if (username == null || password == null) {
                        PasswordAuthentication pa = this.session.getPasswordAuthentication(this.url);
                        if (pa == null) {
                            InetAddress addr = InetAddress.getByName(host);
                            pa = this.session.requestPasswordAuthentication(addr, port, "imap", null, null);
                        }
                        if (pa != null) {
                            username = pa.getUserName();
                            password = pa.getPassword();
                        }
                    }
                    if (username != null && password != null) {
                        String authPrefs = this.getProperty("auth.mechanisms");
                        Iterator i2 = null;
                        if (authPrefs == null) {
                            i2 = authenticationMechanisms.iterator();
                        } else {
                            StringTokenizer st = new StringTokenizer(authPrefs, ",");
                            ArrayList<Object> authPrefList = Collections.list(st);
                            i2 = authPrefList.iterator();
                        }
                        while (i2.hasNext()) {
                            String mechanism = (String)i2.next();
                            if (!authenticationMechanisms.contains(mechanism) || !this.connection.authenticate(mechanism, username, password)) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
                if (capabilities.contains("LOGINDISABLED")) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.connection.login(username, password);
                return bl;
            }
            catch (UnknownHostException e) {
                throw new MessagingException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), e);
            }
            finally {
                if (this.connection != null && this.connection.alertsPending()) {
                    this.processAlerts();
                }
            }
        }
    }

    protected TrustManager getTrustManager() throws MessagingException {
        String tmt = this.getProperty("trustmanager");
        if (tmt == null) {
            return null;
        }
        try {
            Class<?> t = Class.forName(tmt);
            TrustManager tm = (TrustManager)t.newInstance();
            try {
                Class[] pt = new Class[]{Session.class};
                Method m = t.getMethod("setSession", pt);
                Object[] args = new Object[]{this.session};
                m.invoke((Object)tm, args);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            return tm;
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws MessagingException {
        if (this.connection != null) {
            IMAPStore iMAPStore = this;
            synchronized (iMAPStore) {
                try {
                    this.connection.logout();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.connection = null;
            }
        }
        super.close();
    }

    public Folder getDefaultFolder() throws MessagingException {
        if (this.root == null) {
            this.root = new IMAPFolder(this, "");
        }
        return this.root;
    }

    public Folder getFolder(String name) throws MessagingException {
        return new IMAPFolder(this, name);
    }

    public Folder getFolder(URLName urlname) throws MessagingException {
        return this.getFolder(urlname.getFile());
    }

    protected IMAPConnection getConnection() throws StoreClosedException {
        if (!this.isConnected()) {
            throw new StoreClosedException(this);
        }
        return this.connection;
    }

    protected boolean isSelected(IMAPFolder folder) {
        return folder.equals(this.selected);
    }

    protected void setSelected(IMAPFolder folder) {
        this.selected = folder;
    }

    protected void processAlerts() {
        String[] alerts = this.connection.getAlerts();
        for (int i = 0; i < alerts.length; ++i) {
            this.notifyStoreListeners(1, alerts[i]);
        }
    }

    public Folder[] getPersonalNamespaces() throws MessagingException {
        if (!this.isConnected()) {
            throw new StoreClosedException(this);
        }
        IMAPStore iMAPStore = this;
        synchronized (iMAPStore) {
            try {
                Namespaces ns = this.connection.namespace();
                if (ns == null) {
                    throw new MethodNotSupportedException("IMAP NAMESPACE command not supported");
                }
                Namespaces.Namespace[] n = ns.getPersonal();
                Folder[] f = new Folder[n.length];
                for (int i = 0; i < n.length; ++i) {
                    String prefix = n[i].getPrefix();
                    char delimiter = n[i].getDelimiter();
                    f[i] = new IMAPFolder(this, prefix, delimiter);
                }
                return f;
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
    }

    public Folder[] getUserNamespaces() throws MessagingException {
        if (!this.isConnected()) {
            throw new StoreClosedException(this);
        }
        IMAPStore iMAPStore = this;
        synchronized (iMAPStore) {
            try {
                Namespaces ns = this.connection.namespace();
                if (ns == null) {
                    throw new MethodNotSupportedException("IMAP NAMESPACE command not supported");
                }
                Namespaces.Namespace[] n = ns.getOther();
                Folder[] f = new Folder[n.length];
                for (int i = 0; i < n.length; ++i) {
                    String prefix = n[i].getPrefix();
                    char delimiter = n[i].getDelimiter();
                    f[i] = new IMAPFolder(this, prefix, delimiter);
                }
                return f;
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        if (!this.isConnected()) {
            throw new StoreClosedException(this);
        }
        IMAPStore iMAPStore = this;
        synchronized (iMAPStore) {
            try {
                Namespaces ns = this.connection.namespace();
                if (ns == null) {
                    throw new MethodNotSupportedException("IMAP NAMESPACE command not supported");
                }
                Namespaces.Namespace[] n = ns.getShared();
                Folder[] f = new Folder[n.length];
                for (int i = 0; i < n.length; ++i) {
                    String prefix = n[i].getPrefix();
                    char delimiter = n[i].getDelimiter();
                    f[i] = new IMAPFolder(this, prefix, delimiter);
                }
                return f;
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
    }

    public Quota getQuota(String root) throws MessagingException {
        if (!this.isConnected()) {
            throw new StoreClosedException(this);
        }
        IMAPStore iMAPStore = this;
        synchronized (iMAPStore) {
            try {
                return this.connection.getquota(root);
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuota(String root, Quota.Resource[] resources) throws MessagingException {
        if (!this.isConnected()) {
            throw new StoreClosedException(this);
        }
        IMAPStore iMAPStore = this;
        synchronized (iMAPStore) {
            try {
                this.connection.setquota(root, resources);
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
    }

    private int getIntProperty(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    private boolean propertyIsFalse(String key) {
        return "false".equals(this.getProperty(key));
    }

    private boolean propertyIsTrue(String key) {
        return "true".equals(this.getProperty(key));
    }

    private String getProperty(String key) {
        String value = this.session.getProperty("mail.imap." + key);
        if (value == null) {
            value = this.session.getProperty("mail." + key);
        }
        return value;
    }
}

