/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.nntp;

import gnu.mail.providers.nntp.NNTPRootFolder;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import org.jpackage.mail.inet.nntp.FileNewsrc;
import org.jpackage.mail.inet.nntp.NNTPConnection;
import org.jpackage.mail.inet.nntp.Newsrc;

public class NNTPStore
extends Store {
    static final Logger logger = Logger.getLogger("gnu.mail.providers.nntp");
    static final Level NNTP_TRACE = NNTPConnection.NNTP_TRACE;
    NNTPConnection connection;
    Newsrc newsrc;
    Folder root;
    Flags permanentFlags = new Flags();

    public NNTPStore(Session session, URLName url) {
        super(session, url);
        this.permanentFlags.add(Flags.Flag.RECENT);
        this.permanentFlags.add(Flags.Flag.SEEN);
        String tn = this.getProperty("newsrc");
        if (tn != null) {
            logger.log(NNTP_TRACE, "ERROR: unable to instantiate newsrc");
        } else {
            File baseFile;
            String baseFilename = ".newsrc";
            StringBuffer buffer = new StringBuffer(baseFilename);
            if (url != null) {
                buffer.append('-');
                buffer.append(url.getHost());
            }
            String filename = buffer.toString();
            String home = System.getProperty("user.home");
            File file = new File(home, filename);
            if (!file.exists() && (baseFile = new File(home, baseFilename)).exists()) {
                file = baseFile;
            }
            this.newsrc = new FileNewsrc(file, session.getDebug());
        }
    }

    protected boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        if (this.connection != null) {
            return true;
        }
        if (host == null) {
            host = this.getProperty("host");
        }
        if (username == null) {
            username = this.getProperty("user");
        }
        if (port < 0) {
            port = this.getIntProperty("port");
        }
        if (host == null) {
            return false;
        }
        try {
            int connectionTimeout = this.getIntProperty("connectiontimeout");
            int timeout = this.getIntProperty("timeout");
            if (port < 0) {
                port = 119;
            }
            if (this.session.getDebug()) {
                NNTPConnection.logger.setLevel(NNTPConnection.NNTP_TRACE);
            }
            this.connection = new NNTPConnection(host, port, connectionTimeout, timeout);
            if (username != null && password != null) {
                return this.connection.authinfo(username, password);
            }
            return true;
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MessagingException {
        try {
            this.newsrc.close();
            NNTPConnection nNTPConnection = this.connection;
            synchronized (nNTPConnection) {
                this.connection.quit();
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), e);
        }
        super.close();
    }

    public Folder getDefaultFolder() throws MessagingException {
        if (this.root == null) {
            this.root = new NNTPRootFolder(this);
        }
        return this.root;
    }

    public Folder getFolder(String name) throws MessagingException {
        return this.getDefaultFolder().getFolder(name);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        return this.getDefaultFolder().getFolder(url.getFile());
    }

    boolean isListAll() {
        return this.propertyIsTrue("listall");
    }

    private int getIntProperty(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return -1;
    }

    private boolean propertyIsFalse(String key) {
        return "false".equals(this.getProperty(key));
    }

    private boolean propertyIsTrue(String key) {
        return "true".equals(this.getProperty(key));
    }

    private String getProperty(String key) {
        String value = this.session.getProperty("mail.nntp." + key);
        if (value == null) {
            value = this.session.getProperty("mail." + key);
        }
        return value;
    }
}

