/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class QPInputStream
extends FilterInputStream {
    protected byte[] buf = new byte[2];
    protected int spaceCount;
    private static final int LF = 10;
    private static final int CR = 13;
    private static final int SPACE = 32;
    private static final int EQ = 61;

    public QPInputStream(InputStream in) {
        super(new PushbackInputStream(in, 2));
    }

    public int read() throws IOException {
        if (this.spaceCount > 0) {
            --this.spaceCount;
            return 32;
        }
        int c = this.in.read();
        if (c == 32) {
            while ((c = this.in.read()) == 32) {
                ++this.spaceCount;
            }
            if (c == 10 || c == 13 || c == -1) {
                this.spaceCount = 0;
            } else {
                ((PushbackInputStream)this.in).unread(c);
                c = 32;
            }
            return c;
        }
        if (c == 61) {
            int c2 = this.in.read();
            if (c2 == 10) {
                return this.read();
            }
            if (c2 == 13) {
                int peek = this.in.read();
                if (peek != 10) {
                    ((PushbackInputStream)this.in).unread(peek);
                }
                return this.read();
            }
            if (c2 == -1) {
                return c2;
            }
            this.buf[0] = (byte)c2;
            this.buf[1] = (byte)this.in.read();
            try {
                return Integer.parseInt(new String(this.buf, 0, 2), 16);
            }
            catch (NumberFormatException e) {
                ((PushbackInputStream)this.in).unread(this.buf);
                return c;
            }
        }
        return c;
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        int pos;
        try {
            for (pos = 0; pos < len; ++pos) {
                int c = this.read();
                if (c == -1) {
                    if (pos == 0) {
                        pos = -1;
                    }
                    break;
                }
                bytes[off + pos] = (byte)c;
            }
        }
        catch (IOException e) {
            pos = -1;
        }
        return pos;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return this.in.available();
    }
}

