/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RFC2822OutputStream
extends FilterOutputStream {
    public static final int CR = 13;
    public static final int LF = 10;
    protected int count = 0;

    public RFC2822OutputStream(OutputStream out) {
        super(out);
    }

    public void write(int ch) throws IOException {
        if (ch == 13 || ch == 10) {
            this.out.write(ch);
            this.count = 0;
        } else {
            if (this.count > 998) {
                this.out.write(10);
                this.count = 0;
            }
            this.out.write(ch);
            ++this.count;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int i;
        int d = off;
        len += off;
        for (i = off; i < len; ++i) {
            ++this.count;
            if (b[i] == 13 || b[i] == 10) {
                this.out.write(b, d, i + 1 - d);
                d = i + 1;
                this.count = 0;
                continue;
            }
            if (this.count <= 998) continue;
            this.out.write(b, d, this.count);
            this.out.write(10);
            d = i + 1;
            this.count = 0;
        }
        int leftToWrite = i - d;
        if (leftToWrite > 0) {
            this.out.write(b, d, leftToWrite);
        }
    }
}

