/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.mail.Header;
import javax.mail.MessagingException;
import org.jpackage.mail.inet.util.LineInputStream;

public class InternetHeaders {
    private ArrayList headers = new ArrayList(20);

    public InternetHeaders() {
        this.headers.add(new InternetHeader("Return-Path", null));
        this.headers.add(new InternetHeader("Received", null));
        this.headers.add(new InternetHeader("Message-Id", null));
        this.headers.add(new InternetHeader("Resent-Date", null));
        this.headers.add(new InternetHeader("Date", null));
        this.headers.add(new InternetHeader("Resent-From", null));
        this.headers.add(new InternetHeader("From", null));
        this.headers.add(new InternetHeader("Reply-To", null));
        this.headers.add(new InternetHeader("To", null));
        this.headers.add(new InternetHeader("Subject", null));
        this.headers.add(new InternetHeader("Cc", null));
        this.headers.add(new InternetHeader("In-Reply-To", null));
        this.headers.add(new InternetHeader("Resent-Message-Id", null));
        this.headers.add(new InternetHeader("Errors-To", null));
        this.headers.add(new InternetHeader("Mime-Version", null));
        this.headers.add(new InternetHeader("Content-Type", null));
        this.headers.add(new InternetHeader("Content-Transfer-Encoding", null));
        this.headers.add(new InternetHeader("Content-MD5", null));
        this.headers.add(new InternetHeader("Content-Length", null));
        this.headers.add(new InternetHeader("Status", null));
    }

    public InternetHeaders(InputStream is) throws MessagingException {
        this.load(is);
    }

    public void load(InputStream is) throws MessagingException {
        LineInputStream in = new LineInputStream(is);
        try {
            String line = in.readLine();
            while (line != null && (line = InternetHeaders.trim(line)).length() != 0) {
                this.addHeaderLine(line);
                line = in.readLine();
            }
        }
        catch (IOException e) {
            throw new MessagingException("I/O error", e);
        }
    }

    public String[] getHeader(String name) {
        ArrayList<String> acc = new ArrayList<String>(this.headers.size());
        Iterator i = this.headers.iterator();
        while (i.hasNext()) {
            InternetHeader header = (InternetHeader)i.next();
            if (!header.nameEquals(name) || header.line == null) continue;
            acc.add(header.getValue());
        }
        int size = acc.size();
        if (size == 0) {
            return null;
        }
        String[] h = new String[size];
        acc.toArray(h);
        return h;
    }

    public String getHeader(String name, String delimiter) {
        String[] h = this.getHeader(name);
        if (h == null) {
            return null;
        }
        if (delimiter == null || h.length == 1) {
            return h[0];
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < h.length; ++i) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(h[i]);
        }
        return buffer.toString();
    }

    public void setHeader(String name, String value) {
        boolean first = true;
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (!header.nameEquals(name)) continue;
            if (first) {
                header.setValue(value);
                first = false;
                continue;
            }
            this.headers.remove(i);
            --i;
        }
        if (first) {
            this.addHeader(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String name, String value) {
        ArrayList arrayList = this.headers;
        synchronized (arrayList) {
            int len = this.headers.size();
            for (int i = len - 1; i >= 0; --i) {
                InternetHeader header = (InternetHeader)this.headers.get(i);
                if (header.nameEquals(name)) {
                    this.headers.add(i + 1, new InternetHeader(name, value));
                    return;
                }
                if (!header.nameEquals(":")) continue;
                len = i;
            }
            this.headers.add(len, new InternetHeader(name, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHeader(String name) {
        ArrayList arrayList = this.headers;
        synchronized (arrayList) {
            int len = this.headers.size();
            for (int i = 0; i < len; ++i) {
                InternetHeader header = (InternetHeader)this.headers.get(i);
                if (!header.nameEquals(name)) continue;
                header.line = null;
            }
        }
    }

    public Enumeration getAllHeaders() {
        return new HeaderEnumeration(this.headers.iterator(), null, false, false);
    }

    public Enumeration getMatchingHeaders(String[] names) {
        return new HeaderEnumeration(this.headers.iterator(), names, false, true);
    }

    public Enumeration getNonMatchingHeaders(String[] names) {
        return new HeaderEnumeration(this.headers.iterator(), names, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeaderLine(String line) {
        block7: {
            try {
                char c = line.charAt(0);
                if (c == ' ' || c == '\t') {
                    int len = this.headers.size();
                    InternetHeader header = (InternetHeader)this.headers.get(len - 1);
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(header.line);
                    buffer.append("\r\n");
                    buffer.append(line);
                    header.line = buffer.toString();
                    break block7;
                }
                ArrayList arrayList = this.headers;
                synchronized (arrayList) {
                    this.headers.add(new InternetHeader(line));
                }
            }
            catch (StringIndexOutOfBoundsException e) {
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public Enumeration getAllHeaderLines() {
        return new HeaderEnumeration(this.headers.iterator(), null, true, false);
    }

    public Enumeration getMatchingHeaderLines(String[] names) {
        return new HeaderEnumeration(this.headers.iterator(), names, true, true);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) {
        return new HeaderEnumeration(this.headers.iterator(), names, true, false);
    }

    private static String trim(String line) {
        int len = line.length();
        if (len > 0 && line.charAt(len - 1) == '\r') {
            line = line.substring(0, len - 1);
        }
        return line;
    }

    static class HeaderEnumeration
    implements Iterator,
    Enumeration {
        private Iterator source;
        private String[] names;
        private boolean stringForm;
        private boolean matching;
        private InternetHeader nextHeader;

        HeaderEnumeration(Iterator source, String[] names, boolean stringForm, boolean matching) {
            this.source = source;
            this.names = names;
            this.stringForm = stringForm;
            this.matching = matching;
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public boolean hasNext() {
            if (this.nextHeader == null) {
                this.nextHeader = this.getNext();
            }
            return this.nextHeader != null;
        }

        public Object nextElement() {
            return this.next();
        }

        public Object next() {
            if (this.nextHeader == null) {
                this.nextHeader = this.getNext();
            }
            if (this.nextHeader == null) {
                throw new NoSuchElementException();
            }
            InternetHeader header = this.nextHeader;
            this.nextHeader = null;
            if (this.stringForm) {
                return header.line;
            }
            return header;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private InternetHeader getNext() {
            while (this.source.hasNext()) {
                InternetHeader header = (InternetHeader)this.source.next();
                if (header.line == null) continue;
                if (this.names == null) {
                    return this.matching ? null : header;
                }
                for (int i = 0; i < this.names.length; ++i) {
                    if (!header.nameEquals(this.names[i])) continue;
                    if (this.matching) {
                        return header;
                    }
                    return this.getNext();
                }
                if (this.matching) continue;
                return header;
            }
            return null;
        }
    }

    static class InternetHeader
    extends Header {
        String name;
        String line;

        InternetHeader(String line) {
            super(null, null);
            int i = line.indexOf(58);
            this.name = i < 0 ? line.trim() : line.substring(0, i).trim();
            this.line = line;
        }

        InternetHeader(String name, String value) {
            super(null, null);
            this.name = name;
            if (value != null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(name);
                buffer.append(':');
                buffer.append(' ');
                buffer.append(value);
                this.line = buffer.toString();
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            char c;
            int pos;
            int i = this.line.indexOf(58);
            if (i < 0) {
                return this.line;
            }
            int len = this.line.length();
            for (pos = i + 1; pos < len && ((c = this.line.charAt(pos)) == ' ' || c == '\t' || c == '\r' || c == '\n'); ++pos) {
            }
            return this.line.substring(pos);
        }

        void setValue(String value) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.name);
            buffer.append(':');
            buffer.append(' ');
            buffer.append(value);
            this.line = buffer.toString();
        }

        boolean nameEquals(String other) {
            return this.name.equalsIgnoreCase(other);
        }
    }
}

