/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.NewsAddress;
import javax.mail.internet.SharedInputStream;

public class MimeMessage
extends Message
implements MimePart {
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;
    protected Flags flags;
    protected boolean modified;
    protected boolean saved;
    private static MailDateFormat dateFormat = new MailDateFormat();
    static final String TO_NAME = "To";
    static final String CC_NAME = "Cc";
    static final String BCC_NAME = "Bcc";
    static final String NEWSGROUPS_NAME = "Newsgroups";
    static final String FROM_NAME = "From";
    static final String SENDER_NAME = "Sender";
    static final String REPLY_TO_NAME = "Reply-To";
    static final String SUBJECT_NAME = "Subject";
    static final String DATE_NAME = "Date";
    static final String MESSAGE_ID_NAME = "Message-ID";
    static int fc = 1;

    public MimeMessage(Session session) {
        super(session);
        this.headers = new InternetHeaders();
        this.flags = new Flags();
        this.modified = true;
    }

    public MimeMessage(Session session, InputStream is) throws MessagingException {
        super(session);
        this.flags = new Flags();
        this.parse(is);
        this.saved = true;
    }

    public MimeMessage(MimeMessage source) throws MessagingException {
        super(source.session);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            source.writeTo(bos);
            bos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            this.parse(bis);
            bis.close();
            this.saved = true;
        }
        catch (IOException e) {
            throw new MessagingException("I/O error", e);
        }
    }

    protected MimeMessage(Folder folder, int msgnum) {
        super(folder, msgnum);
        this.flags = new Flags();
        this.saved = true;
    }

    protected MimeMessage(Folder folder, InputStream is, int msgnum) throws MessagingException {
        this(folder, msgnum);
        this.parse(is);
    }

    protected MimeMessage(Folder folder, InternetHeaders headers, byte[] content, int msgnum) throws MessagingException {
        this(folder, msgnum);
        this.headers = headers;
        this.content = content;
    }

    protected void parse(InputStream is) throws MessagingException {
        if (is instanceof SharedInputStream) {
            this.headers = this.createInternetHeaders(is);
            SharedInputStream sis = (SharedInputStream)((Object)is);
            this.contentStream = sis.newStream(sis.getPosition(), -1L);
        } else {
            if (!(is instanceof ByteArrayInputStream) && !(is instanceof BufferedInputStream)) {
                is = new BufferedInputStream(is);
            }
            this.headers = this.createInternetHeaders(is);
            try {
                int len = 1024;
                if (is instanceof ByteArrayInputStream) {
                    len = is.available();
                    this.content = new byte[len];
                    is.read(this.content, 0, len);
                } else {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(len);
                    byte[] b = new byte[len];
                    int l = is.read(b);
                    while (l != -1) {
                        bos.write(b, 0, l);
                        l = is.read(b);
                    }
                    this.content = bos.toByteArray();
                }
            }
            catch (IOException e) {
                throw new MessagingException("I/O error", e);
            }
        }
        this.modified = false;
    }

    public Address[] getFrom() throws MessagingException {
        Address[] from = this.getInternetAddresses(FROM_NAME);
        if (from == null) {
            from = this.getInternetAddresses(SENDER_NAME);
        }
        return from;
    }

    public void setFrom(Address address) throws MessagingException {
        if (address == null) {
            this.removeHeader(FROM_NAME);
        } else {
            this.setHeader(FROM_NAME, address.toString());
        }
    }

    public void setFrom() throws MessagingException {
        InternetAddress localAddress = InternetAddress.getLocalAddress(this.session);
        if (localAddress == null) {
            throw new MessagingException("No local address");
        }
        this.setFrom(localAddress);
    }

    public void addFrom(Address[] addresses) throws MessagingException {
        this.addInternetAddresses(FROM_NAME, addresses);
    }

    public Address getSender() throws MessagingException {
        Address[] sender = this.getInternetAddresses(SENDER_NAME);
        if (sender != null && sender.length > 0) {
            return sender[0];
        }
        return null;
    }

    public void setSender(Address address) throws MessagingException {
        Address[] addresses = new Address[]{address};
        this.addInternetAddresses(SENDER_NAME, addresses);
    }

    public Address[] getRecipients(Message.RecipientType type) throws MessagingException {
        if (type == RecipientType.NEWSGROUPS) {
            String header = this.getHeader(NEWSGROUPS_NAME, ",");
            return header != null ? NewsAddress.parse(header) : null;
        }
        return this.getInternetAddresses(this.getHeader(type));
    }

    public Address[] getAllRecipients() throws MessagingException {
        Address[] recipients = super.getAllRecipients();
        Address[] newsgroups = this.getRecipients(RecipientType.NEWSGROUPS);
        if (newsgroups == null) {
            return recipients;
        }
        if (recipients == null) {
            return newsgroups;
        }
        Address[] both = new Address[recipients.length + newsgroups.length];
        System.arraycopy(recipients, 0, both, 0, recipients.length);
        System.arraycopy(newsgroups, 0, both, recipients.length, newsgroups.length);
        return both;
    }

    public void setRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        if (type == RecipientType.NEWSGROUPS) {
            if (addresses == null || addresses.length == 0) {
                this.removeHeader(NEWSGROUPS_NAME);
            } else {
                this.setHeader(NEWSGROUPS_NAME, NewsAddress.toString(addresses));
            }
        } else {
            this.setInternetAddresses(this.getHeader(type), addresses);
        }
    }

    public void setRecipients(Message.RecipientType type, String addresses) throws MessagingException {
        if (type == RecipientType.NEWSGROUPS) {
            if (addresses == null || addresses.length() == 0) {
                this.removeHeader(NEWSGROUPS_NAME);
            } else {
                this.setHeader(NEWSGROUPS_NAME, addresses);
            }
        } else {
            this.setInternetAddresses(this.getHeader(type), InternetAddress.parse(addresses));
        }
    }

    public void addRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        if (type == RecipientType.NEWSGROUPS) {
            String value = NewsAddress.toString(addresses);
            if (value != null) {
                this.addHeader(NEWSGROUPS_NAME, value);
            }
        } else {
            this.addInternetAddresses(this.getHeader(type), addresses);
        }
    }

    public void addRecipients(Message.RecipientType type, String addresses) throws MessagingException {
        if (type == RecipientType.NEWSGROUPS) {
            if (addresses != null && addresses.length() != 0) {
                this.addHeader(NEWSGROUPS_NAME, addresses);
            }
        } else {
            this.addInternetAddresses(this.getHeader(type), InternetAddress.parse(addresses));
        }
    }

    public Address[] getReplyTo() throws MessagingException {
        Address[] replyTo = this.getInternetAddresses(REPLY_TO_NAME);
        if (replyTo == null) {
            replyTo = this.getFrom();
        }
        return replyTo;
    }

    public void setReplyTo(Address[] addresses) throws MessagingException {
        this.setInternetAddresses(REPLY_TO_NAME, addresses);
    }

    private Address[] getInternetAddresses(String name) throws MessagingException {
        String value = this.getHeader(name, ",");
        String s = this.session.getProperty("mail.mime.address.strict");
        boolean strict = s == null || Boolean.valueOf(s) != false;
        return value != null ? InternetAddress.parseHeader(value, strict) : null;
    }

    private void setInternetAddresses(String name, Address[] addresses) throws MessagingException {
        String line = InternetAddress.toString(addresses);
        if (line == null) {
            this.removeHeader(line);
        } else {
            this.setHeader(name, line);
        }
    }

    private void addInternetAddresses(String name, Address[] addresses) throws MessagingException {
        String line = InternetAddress.toString(addresses);
        if (line != null) {
            this.addHeader(name, line);
        }
    }

    private String getHeader(Message.RecipientType type) throws MessagingException {
        if (type == Message.RecipientType.TO) {
            return TO_NAME;
        }
        if (type == Message.RecipientType.CC) {
            return CC_NAME;
        }
        if (type == Message.RecipientType.BCC) {
            return BCC_NAME;
        }
        if (type == RecipientType.NEWSGROUPS) {
            return NEWSGROUPS_NAME;
        }
        throw new MessagingException("Invalid recipient type");
    }

    public String getSubject() throws MessagingException {
        String subject = this.getHeader(SUBJECT_NAME, null);
        if (subject == null) {
            return null;
        }
        try {
            subject = MimeUtility.decodeText(subject);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return subject;
    }

    public void setSubject(String subject) throws MessagingException {
        this.setSubject(subject, null);
    }

    public void setSubject(String subject, String charset) throws MessagingException {
        if (subject == null) {
            this.removeHeader(SUBJECT_NAME);
        }
        try {
            this.setHeader(SUBJECT_NAME, MimeUtility.encodeText(subject, charset, null));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Encoding error", e);
        }
    }

    public Date getSentDate() throws MessagingException {
        String value = this.getHeader(DATE_NAME, null);
        if (value != null) {
            try {
                return dateFormat.parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setSentDate(Date date) throws MessagingException {
        if (date == null) {
            this.removeHeader(DATE_NAME);
        } else {
            this.setHeader(DATE_NAME, dateFormat.format(date));
        }
    }

    public Date getReceivedDate() throws MessagingException {
        return null;
    }

    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int available = this.contentStream.available();
                if (available > 0) {
                    return available;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String contentType = this.getHeader("Content-Type", null);
        if (contentType == null) {
            return "text/plain";
        }
        return contentType;
    }

    public boolean isMimeType(String mimeType) throws MessagingException {
        return new ContentType(this.getContentType()).match(mimeType);
    }

    public String getDisposition() throws MessagingException {
        String disposition = this.getHeader("Content-Disposition", null);
        if (disposition != null) {
            return new ContentDisposition(disposition).getDisposition();
        }
        return null;
    }

    public void setDisposition(String disposition) throws MessagingException {
        if (disposition == null) {
            this.removeHeader("Content-Disposition");
        } else {
            String value = this.getHeader("Content-Disposition", null);
            if (value != null) {
                ContentDisposition cd = new ContentDisposition(value);
                cd.setDisposition(disposition);
                disposition = cd.toString();
            }
            this.setHeader("Content-Disposition", disposition);
        }
    }

    public String getEncoding() throws MessagingException {
        String encoding = this.getHeader("Content-Transfer-Encoding", null);
        if (encoding != null) {
            if ((encoding = encoding.trim()).equalsIgnoreCase("7bit") || encoding.equalsIgnoreCase("8bit") || encoding.equalsIgnoreCase("quoted-printable") || encoding.equalsIgnoreCase("base64")) {
                return encoding;
            }
            HeaderTokenizer ht = new HeaderTokenizer(encoding, "()<>@,;:\\\"\t []/?=");
            boolean done = false;
            while (!done) {
                HeaderTokenizer.Token token = ht.next();
                switch (token.getType()) {
                    case -4: {
                        done = true;
                        break;
                    }
                    case -1: {
                        return token.getValue();
                    }
                }
            }
            return encoding;
        }
        return null;
    }

    public String getContentID() throws MessagingException {
        return this.getHeader("Content-ID", null);
    }

    public void setContentID(String cid) throws MessagingException {
        if (cid == null) {
            this.removeHeader("Content-ID");
        } else {
            this.setHeader("Content-ID", cid);
        }
    }

    public String getContentMD5() throws MessagingException {
        return this.getHeader("Content-MD5", null);
    }

    public void setContentMD5(String md5) throws MessagingException {
        this.setHeader("Content-MD5", md5);
    }

    public String getDescription() throws MessagingException {
        String header = this.getHeader("Content-Description", null);
        if (header != null) {
            try {
                return MimeUtility.decodeText(header);
            }
            catch (UnsupportedEncodingException e) {
                return header;
            }
        }
        return null;
    }

    public void setDescription(String description) throws MessagingException {
        this.setDescription(description, null);
    }

    public void setDescription(String description, String charset) throws MessagingException {
        if (description != null) {
            try {
                this.setHeader("Content-Description", MimeUtility.encodeText(description, charset, null));
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException("Encode error", e);
            }
        } else {
            this.removeHeader("Content-Description");
        }
    }

    public String[] getContentLanguage() throws MessagingException {
        String header = this.getHeader("Content-Language", null);
        if (header != null) {
            HeaderTokenizer ht = new HeaderTokenizer(header, "()<>@,;:\\\"\t []/?=");
            ArrayList<String> acc = new ArrayList<String>();
            boolean done = false;
            while (!done) {
                HeaderTokenizer.Token token = ht.next();
                switch (token.getType()) {
                    case -4: {
                        done = true;
                        break;
                    }
                    case -1: {
                        acc.add(token.getValue());
                    }
                }
            }
            if (acc.size() > 0) {
                String[] languages = new String[acc.size()];
                acc.toArray(languages);
                return languages;
            }
        }
        return null;
    }

    public void setContentLanguage(String[] languages) throws MessagingException {
        if (languages != null && languages.length > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(languages[0]);
            for (int i = 1; i < languages.length; ++i) {
                buffer.append(',');
                buffer.append(languages[i]);
            }
            this.setHeader("Content-Language", buffer.toString());
        } else {
            this.setHeader("Content-Language", null);
        }
    }

    public String getMessageID() throws MessagingException {
        return this.getHeader(MESSAGE_ID_NAME, null);
    }

    public String getFileName() throws MessagingException {
        String filename = null;
        String header = this.getHeader("Content-Disposition", null);
        if (header != null) {
            ContentDisposition cd = new ContentDisposition(header);
            filename = cd.getParameter("filename");
        }
        if (filename == null && (header = this.getHeader("Content-Type", null)) != null) {
            ContentType contentType = new ContentType(header);
            filename = contentType.getParameter("name");
        }
        return filename;
    }

    public void setFileName(String filename) throws MessagingException {
        String header = this.getHeader("Content-Disposition", null);
        if (header == null) {
            header = "attachment";
        }
        ContentDisposition cd = new ContentDisposition(header);
        cd.setParameter("filename", filename);
        this.setHeader("Content-Disposition", cd.toString());
        header = this.getContentType();
        ContentType contentType = new ContentType(header);
        contentType.setParameter("name", filename);
        this.setHeader("Content-Type", contentType.toString());
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return ((SharedInputStream)((Object)this.contentStream)).newStream(0L, -1L);
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler((DataSource)new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() throws IOException, MessagingException {
        return this.getDataHandler().getContent();
    }

    public void setDataHandler(DataHandler datahandler) throws MessagingException {
        this.dh = datahandler;
        this.removeHeader("Content-Type");
        this.removeHeader("Content-Transfer-Encoding");
    }

    public void setContent(Object o, String type) throws MessagingException {
        this.setDataHandler(new DataHandler(o, type));
    }

    public void setText(String text) throws MessagingException {
        this.setText(text, null);
    }

    public void setText(String text, String charset) throws MessagingException {
        if (charset == null) {
            charset = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("text/plain; charset=");
        buffer.append(MimeUtility.quote(charset, "()<>@,;:\\\"\t []/?="));
        this.setContent(text, buffer.toString());
    }

    public void setContent(Multipart mp) throws MessagingException {
        this.setDataHandler(new DataHandler((Object)mp, mp.getContentType()));
        mp.setParent(this);
    }

    public Message reply(boolean replyToAll) throws MessagingException {
        String mid;
        MimeMessage message = new MimeMessage(this.session);
        String subject = this.getHeader(SUBJECT_NAME, null);
        if (subject != null) {
            if (!subject.startsWith("Re: ")) {
                subject = "Re: " + subject;
            }
            message.setHeader(SUBJECT_NAME, subject);
        }
        Address[] addresses = this.getReplyTo();
        message.setRecipients(Message.RecipientType.TO, addresses);
        if (replyToAll) {
            String alternates;
            HashSet<Address> set = new HashSet<Address>();
            set.addAll(Arrays.asList(addresses));
            InternetAddress localAddress = InternetAddress.getLocalAddress(this.session);
            if (localAddress != null) {
                set.add(localAddress);
            }
            if ((alternates = this.session.getProperty("mail.alternates")) != null) {
                set.addAll(Arrays.asList(InternetAddress.parse(alternates, false)));
            }
            set.addAll(Arrays.asList(this.getRecipients(Message.RecipientType.TO)));
            addresses = new Address[set.size()];
            set.toArray(addresses);
            boolean replyAllCC = new Boolean(this.session.getProperty("mail.replyallcc"));
            if (addresses.length > 0) {
                if (replyAllCC) {
                    message.addRecipients(Message.RecipientType.CC, addresses);
                } else {
                    message.addRecipients(Message.RecipientType.TO, addresses);
                }
            }
            set.clear();
            set.addAll(Arrays.asList(this.getRecipients(Message.RecipientType.CC)));
            addresses = new Address[set.size()];
            set.toArray(addresses);
            if (addresses != null && addresses.length > 0) {
                message.addRecipients(Message.RecipientType.CC, addresses);
            }
            if ((addresses = this.getRecipients(RecipientType.NEWSGROUPS)) != null && addresses.length > 0) {
                message.setRecipients((Message.RecipientType)RecipientType.NEWSGROUPS, addresses);
            }
        }
        if ((mid = this.getHeader(MESSAGE_ID_NAME, null)) != null) {
            message.setHeader("In-Reply-To", mid);
        }
        try {
            this.setFlag(Flags.Flag.ANSWERED, true);
        }
        catch (MessagingException e) {
            // empty catch block
        }
        return message;
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        this.writeTo(os, null);
    }

    public void writeTo(OutputStream os, String[] ignoreList) throws IOException, MessagingException {
        if (!this.saved) {
            this.saveChanges();
        }
        String charset = "US-ASCII";
        byte[] sep = new byte[]{13, 10};
        Enumeration e = this.getNonMatchingHeaderLines(ignoreList);
        while (e.hasMoreElements()) {
            String line = (String)e.nextElement();
            StringTokenizer st = new StringTokenizer(line, "\r\n");
            int count = 0;
            while (st.hasMoreTokens()) {
                int max;
                String line2 = st.nextToken();
                if (count > 0 && line2.charAt(0) != '\t') {
                    os.write(9);
                }
                int n = max = count > 0 ? 997 : 998;
                while (line2.length() > max) {
                    String left = line2.substring(0, max);
                    byte[] bytes = left.getBytes(charset);
                    os.write(bytes);
                    os.write(sep);
                    os.write(9);
                    line2 = line2.substring(max);
                    max = 997;
                }
                byte[] bytes = line2.getBytes(charset);
                os.write(bytes);
                os.write(sep);
                ++count;
            }
        }
        os.write(sep);
        os.flush();
        if (this.modified || this.content == null && this.contentStream == null) {
            os = MimeUtility.encode(os, this.getEncoding());
            this.getDataHandler().writeTo(os);
            os.flush();
        } else {
            if (this.contentStream != null) {
                InputStream is = ((SharedInputStream)((Object)this.contentStream)).newStream(0L, -1L);
                int len = 8192;
                byte[] bytes = new byte[len];
                while ((len = is.read(bytes)) > -1) {
                    os.write(bytes, 0, len);
                }
                is.close();
            } else {
                os.write(this.content);
            }
            os.flush();
        }
    }

    public String[] getHeader(String name) throws MessagingException {
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        return this.headers.getHeader(name, delimiter);
    }

    public void setHeader(String name, String value) throws MessagingException {
        this.headers.setHeader(name, value);
    }

    public void addHeader(String name, String value) throws MessagingException {
        this.headers.addHeader(name, value);
    }

    public void removeHeader(String name) throws MessagingException {
        this.headers.removeHeader(name);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaders(names);
    }

    public void addHeaderLine(String line) throws MessagingException {
        this.headers.addHeaderLine(line);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(names);
    }

    public Flags getFlags() throws MessagingException {
        return (Flags)this.flags.clone();
    }

    public boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.flags.contains(flag);
    }

    public void setFlags(Flags flag, boolean set) throws MessagingException {
        if (set) {
            this.flags.add(flag);
        } else {
            this.flags.remove(flag);
        }
    }

    public void saveChanges() throws MessagingException {
        this.modified = true;
        this.saved = true;
        this.updateHeaders();
    }

    protected void updateHeaders() throws MessagingException {
        if (this.getDataHandler() != null) {
            try {
                String contentType = this.dh.getContentType();
                ContentType ct = new ContentType(contentType);
                if (ct.match("multipart/*")) {
                    MimeMultipart mmp = (MimeMultipart)this.dh.getContent();
                    mmp.updateHeaders();
                } else if (!ct.match("message/rfc822") && this.getHeader("Content-Transfer-Encoding") == null) {
                    this.setHeader("Content-Transfer-Encoding", MimeUtility.getEncoding(this.dh));
                }
                if (this.getHeader("Content-Type") == null) {
                    ContentDisposition cd;
                    String filename;
                    String disposition = this.getHeader("Content-Disposition", null);
                    if (disposition != null && (filename = (cd = new ContentDisposition(disposition)).getParameter("filename")) != null) {
                        ct.setParameter("name", filename);
                        contentType = ct.toString();
                    }
                    this.setHeader("Content-Type", contentType);
                }
            }
            catch (IOException e) {
                throw new MessagingException("I/O error", e);
            }
        }
        this.setHeader("Mime-Version", "1.0");
        String mid = this.getHeader(MESSAGE_ID_NAME, null);
        if (mid == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('<');
            buffer.append(MimeUtility.getUniqueMessageIDValue(this.session));
            buffer.append('>');
            mid = buffer.toString();
            this.setHeader(MESSAGE_ID_NAME, mid);
        }
    }

    protected InternetHeaders createInternetHeaders(InputStream is) throws MessagingException {
        return new InternetHeaders(is);
    }

    public static class RecipientType
    extends Message.RecipientType {
        public static final RecipientType NEWSGROUPS = new RecipientType("Newsgroups");

        protected Object readResolve() throws ObjectStreamException {
            if (this.type.equals(MimeMessage.NEWSGROUPS_NAME)) {
                return NEWSGROUPS;
            }
            return super.readResolve();
        }

        protected RecipientType(String type) {
            super(type);
        }
    }
}

