/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.search.StringTerm;

public final class HeaderTerm
extends StringTerm {
    protected String headerName;

    public HeaderTerm(String headerName, String pattern) {
        super(pattern);
        this.headerName = headerName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public boolean match(Message msg) {
        try {
            String[] headers = msg.getHeader(this.headerName);
            if (headers != null) {
                for (int i = 0; i < headers.length; ++i) {
                    if (!super.match(headers[i])) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof HeaderTerm) {
            HeaderTerm ht = (HeaderTerm)other;
            return ht.headerName.equalsIgnoreCase(this.headerName) && super.equals(ht);
        }
        return false;
    }

    public int hashCode() {
        return this.headerName.toLowerCase().hashCode() + super.hashCode();
    }
}

