/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jpackage.mail.inet.ftp.BlockInputStream;
import org.jpackage.mail.inet.ftp.BlockOutputStream;
import org.jpackage.mail.inet.ftp.CompressedInputStream;
import org.jpackage.mail.inet.ftp.CompressedOutputStream;
import org.jpackage.mail.inet.ftp.DTP;
import org.jpackage.mail.inet.ftp.DTPInputStream;
import org.jpackage.mail.inet.ftp.DTPOutputStream;
import org.jpackage.mail.inet.ftp.StreamInputStream;
import org.jpackage.mail.inet.ftp.StreamOutputStream;

final class ActiveModeDTP
implements DTP,
Runnable {
    ServerSocket server;
    Socket socket;
    DTPInputStream in;
    DTPOutputStream out;
    boolean completed = false;
    boolean inProgress = false;
    int transferMode;
    IOException exception;
    Thread acceptThread;
    int connectionTimeout;

    ActiveModeDTP(InetAddress localhost, int port, int connectionTimeout, int timeout) throws IOException {
        this.server = new ServerSocket(port, 1, localhost);
        if (timeout > 0) {
            this.server.setSoTimeout(timeout);
        }
        if (connectionTimeout <= 0) {
            connectionTimeout = 20000;
        }
        this.connectionTimeout = connectionTimeout;
        this.acceptThread = new Thread((Runnable)this, "ActiveModeDTP");
        this.acceptThread.start();
    }

    public void run() {
        try {
            this.socket = this.server.accept();
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    public void waitFor() throws IOException {
        try {
            this.acceptThread.join(this.connectionTimeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.socket == null) {
            this.server.close();
            throw new IOException("client did not connect before timeout");
        }
        this.acceptThread = null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inProgress) {
            throw new IOException("Transfer in progress");
        }
        if (this.acceptThread != null) {
            this.waitFor();
        }
        switch (this.transferMode) {
            case 1: {
                this.in = new StreamInputStream(this, this.socket.getInputStream());
                break;
            }
            case 2: {
                this.in = new BlockInputStream(this, this.socket.getInputStream());
                break;
            }
            case 3: {
                this.in = new CompressedInputStream(this, this.socket.getInputStream());
                break;
            }
            default: {
                throw new IllegalStateException("invalid transfer mode");
            }
        }
        this.in.setTransferComplete(false);
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.inProgress) {
            throw new IOException("Transfer in progress");
        }
        if (this.acceptThread != null) {
            this.waitFor();
        }
        switch (this.transferMode) {
            case 1: {
                this.out = new StreamOutputStream(this, this.socket.getOutputStream());
                break;
            }
            case 2: {
                this.out = new BlockOutputStream(this, this.socket.getOutputStream());
                break;
            }
            case 3: {
                this.out = new CompressedOutputStream(this, this.socket.getOutputStream());
                break;
            }
            default: {
                throw new IllegalStateException("invalid transfer mode");
            }
        }
        this.out.setTransferComplete(false);
        return this.out;
    }

    public void setTransferMode(int mode) {
        this.transferMode = mode;
    }

    public void complete() {
        this.completed = true;
        if (!this.inProgress) {
            this.transferComplete();
        }
    }

    public boolean abort() {
        this.completed = true;
        this.transferComplete();
        return this.inProgress;
    }

    public void transferComplete() {
        if (this.socket == null) {
            return;
        }
        if (this.in != null) {
            this.in.setTransferComplete(true);
        }
        if (this.out != null) {
            this.out.setTransferComplete(true);
        }
        boolean bl = this.completed = this.completed || this.transferMode == 1;
        if (this.completed && this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

