/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.ftp;

import java.io.IOException;
import java.io.OutputStream;
import org.jpackage.mail.inet.ftp.DTP;
import org.jpackage.mail.inet.ftp.DTPOutputStream;

class BlockOutputStream
extends DTPOutputStream {
    static final byte RECORD = -128;
    static final byte EOF = 64;

    BlockOutputStream(DTP dtp, OutputStream out) {
        super(dtp, out);
    }

    public void write(int c) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] buf = new byte[]{-128, 0, 1, (byte)c};
        this.out.write(buf, 0, 4);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] buf = new byte[len + 3];
        buf[0] = -128;
        buf[1] = (byte)((len & 0xFF) >> 8);
        buf[2] = (byte)(len & 0xFF00);
        System.arraycopy(b, off, buf, 3, len);
        this.out.write(buf, 0, len);
    }

    public void close() throws IOException {
        byte[] buf = new byte[]{64, 0, 0};
        this.out.write(buf, 0, 3);
        super.close();
    }
}

