/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.jpackage.mail.inet.ftp.BlockInputStream;
import org.jpackage.mail.inet.ftp.BlockOutputStream;
import org.jpackage.mail.inet.ftp.CompressedInputStream;
import org.jpackage.mail.inet.ftp.CompressedOutputStream;
import org.jpackage.mail.inet.ftp.DTP;
import org.jpackage.mail.inet.ftp.DTPInputStream;
import org.jpackage.mail.inet.ftp.DTPOutputStream;
import org.jpackage.mail.inet.ftp.StreamInputStream;
import org.jpackage.mail.inet.ftp.StreamOutputStream;

final class PassiveModeDTP
implements DTP {
    final String address;
    final int port;
    Socket socket;
    DTPInputStream in;
    DTPOutputStream out;
    boolean completed;
    boolean inProgress;
    int transferMode;

    PassiveModeDTP(String address, int port, InetAddress localhost, int connectionTimeout, int timeout) throws IOException {
        this.address = address;
        this.port = port;
        this.completed = false;
        this.inProgress = false;
        this.socket = new Socket();
        InetSocketAddress remote = new InetSocketAddress(address, port);
        InetSocketAddress local = new InetSocketAddress(localhost, port + 1);
        this.socket.bind(local);
        if (connectionTimeout > 0) {
            this.socket.connect(remote, connectionTimeout);
        } else {
            this.socket.connect(remote);
        }
        if (timeout > 0) {
            this.socket.setSoTimeout(timeout);
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.inProgress) {
            throw new IOException("Transfer in progress");
        }
        switch (this.transferMode) {
            case 1: {
                this.in = new StreamInputStream(this, this.socket.getInputStream());
                break;
            }
            case 2: {
                this.in = new BlockInputStream(this, this.socket.getInputStream());
                break;
            }
            case 3: {
                this.in = new CompressedInputStream(this, this.socket.getInputStream());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid transfer mode");
            }
        }
        this.in.setTransferComplete(false);
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.inProgress) {
            throw new IOException("Transfer in progress");
        }
        switch (this.transferMode) {
            case 1: {
                this.out = new StreamOutputStream(this, this.socket.getOutputStream());
                break;
            }
            case 2: {
                this.out = new BlockOutputStream(this, this.socket.getOutputStream());
                break;
            }
            case 3: {
                this.out = new CompressedOutputStream(this, this.socket.getOutputStream());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid transfer mode");
            }
        }
        this.out.setTransferComplete(false);
        return this.out;
    }

    public void setTransferMode(int mode) {
        this.transferMode = mode;
    }

    public void complete() {
        this.completed = true;
        if (!this.inProgress) {
            this.transferComplete();
        }
    }

    public boolean abort() {
        this.completed = true;
        this.transferComplete();
        return this.inProgress;
    }

    public void transferComplete() {
        if (this.in != null) {
            this.in.setTransferComplete(true);
        }
        if (this.out != null) {
            this.out.setTransferComplete(true);
        }
        this.inProgress = false;
        boolean bl = this.completed = this.completed || this.transferMode == 1;
        if (this.completed && this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

