/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.gopher;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jpackage.mail.inet.gopher.DirectoryEntry;
import org.jpackage.mail.inet.util.LineInputStream;

public final class DirectoryListing
implements Iterator {
    private static final String DOT = ".";
    private LineInputStream in;
    private boolean doneRead = false;
    private DirectoryEntry current;

    DirectoryListing(InputStream in) {
        this.in = new LineInputStream(in);
    }

    public boolean hasNext() {
        try {
            this.fetch();
        }
        catch (IOException e) {
            return false;
        }
        return this.current != null;
    }

    public Object next() {
        try {
            return this.nextEntry();
        }
        catch (IOException e) {
            throw new NoSuchElementException("I/O error: " + e.getMessage());
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public DirectoryEntry nextEntry() throws IOException {
        this.fetch();
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        this.doneRead = false;
        return this.current;
    }

    void fetch() throws IOException {
        if (this.doneRead) {
            return;
        }
        String line = this.in.readLine();
        if (DOT.equals(line)) {
            this.current = null;
        } else {
            int type = 51;
            switch (line.charAt(0)) {
                case '0': {
                    type = 48;
                    break;
                }
                case '1': {
                    type = 49;
                    break;
                }
                case '2': {
                    type = 50;
                    break;
                }
                case '3': {
                    type = 51;
                    break;
                }
                case '4': {
                    type = 52;
                    break;
                }
                case '5': {
                    type = 53;
                    break;
                }
                case '6': {
                    type = 54;
                    break;
                }
                case '7': {
                    type = 55;
                    break;
                }
                case '8': {
                    type = 56;
                    break;
                }
                case '9': {
                    type = 57;
                    break;
                }
                case '+': {
                    type = 43;
                    break;
                }
                case 'T': {
                    type = 84;
                    break;
                }
                case 'g': {
                    type = 103;
                    break;
                }
                case 'I': {
                    type = 73;
                }
            }
            int start = 1;
            int end = line.indexOf(9, start);
            if (end == -1) {
                throw new ProtocolException("Invalid directory entry: " + line);
            }
            String title = line.substring(start, end);
            start = end + 1;
            if ((end = line.indexOf(9, start)) == -1) {
                throw new ProtocolException("Invalid directory entry: " + line);
            }
            String selector = line.substring(start, end);
            start = end + 1;
            if ((end = line.indexOf(9, start)) == -1) {
                throw new ProtocolException("Invalid directory entry: " + line);
            }
            String hostname = line.substring(start, end);
            start = end + 1;
            int port = Integer.parseInt(line.substring(start));
            this.current = new DirectoryEntry(type, title, selector, hostname, port);
        }
    }
}

