/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.imap;

import java.util.List;

public class IMAPResponse {
    public static final String UNTAGGED = "*";
    public static final String CONTINUATION = "+";
    protected String tag = null;
    protected String id = null;
    protected int count = -1;
    protected String mailbox = null;
    protected List code = null;
    protected String text;

    public String getTag() {
        return this.tag;
    }

    public boolean isTagged() {
        return this.tag != UNTAGGED && this.tag != CONTINUATION;
    }

    public boolean isUntagged() {
        return this.tag == UNTAGGED;
    }

    public boolean isContinuation() {
        return this.tag == CONTINUATION;
    }

    public String getID() {
        return this.id;
    }

    public int getCount() {
        return this.count;
    }

    public List getResponseCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public String toANSIString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.tag);
        if (this.count != -1) {
            buffer.append(" \u001b[00;31m");
            buffer.append(this.count);
            buffer.append("\u001b[00m");
        }
        if (!this.isContinuation()) {
            buffer.append(" \u001b[01m");
            buffer.append(this.id);
            buffer.append("\u001b[00m");
        }
        if (this.mailbox != null) {
            buffer.append(" \u001b[00;35m");
            buffer.append(this.mailbox);
            buffer.append("\u001b[00m");
        }
        if (this.code != null) {
            buffer.append(" \u001b[00;36m");
            buffer.append(this.code);
            buffer.append("\u001b[00m");
        }
        if (this.text != null) {
            buffer.append(" \u001b[00;33m");
            buffer.append(this.text);
            buffer.append("\u001b[00m");
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.tag);
        if (this.count != -1) {
            buffer.append(' ');
            buffer.append(this.count);
        }
        if (!this.isContinuation()) {
            buffer.append(' ');
            buffer.append(this.id);
        }
        if (this.mailbox != null) {
            buffer.append(' ');
            buffer.append(this.mailbox);
        }
        if (this.code != null) {
            buffer.append(' ');
            buffer.append(this.code);
        }
        if (this.text != null) {
            buffer.append(' ');
            buffer.append(this.text);
        }
        return buffer.toString();
    }
}

