/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.imap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class UTF7imap {
    private static final String US_ASCII = "US-ASCII";
    private static final byte[] src;
    private static final byte[] dst;

    private UTF7imap() {
    }

    static byte[] encode(byte[] bs) {
        int ti = 0;
        byte[] bt = new byte[(bs.length + 2) / 3 * 4 - 1];
        for (int si = 0; si < bs.length; si += 3) {
            byte b2;
            byte b1;
            int buflen = bs.length - si;
            if (buflen == 1) {
                byte b = bs[si];
                int i = 0;
                boolean flag = false;
                bt[ti++] = src[b >>> 2 & 0x3F];
                bt[ti++] = src[(b << 4 & 0x30) + (i >>> 4 & 0xF)];
                continue;
            }
            if (buflen == 2) {
                b1 = bs[si];
                b2 = bs[si + 1];
                int i = 0;
                bt[ti++] = src[b1 >>> 2 & 0x3F];
                bt[ti++] = src[(b1 << 4 & 0x30) + (b2 >>> 4 & 0xF)];
                bt[ti++] = src[(b2 << 2 & 0x3C) + (i >>> 6 & 3)];
                continue;
            }
            if (buflen != 3) continue;
            b1 = bs[si];
            b2 = bs[si + 1];
            byte b3 = bs[si + 2];
            bt[ti++] = src[b1 >>> 2 & 0x3F];
            bt[ti++] = src[(b1 << 4 & 0x30) + (b2 >>> 4 & 0xF)];
            bt[ti++] = src[(b2 << 2 & 0x3C) + (b3 >>> 6 & 3)];
            bt[ti++] = src[b3 & 0x3F];
        }
        return bt;
    }

    static int[] decode(byte[] bs) {
        int[] buffer = new int[bs.length];
        int buflen = 0;
        int si = 0;
        int len = bs.length - si;
        while (len > 0) {
            byte b0 = dst[bs[si++] & 0xFF];
            byte b2 = dst[bs[si++] & 0xFF];
            buffer[buflen++] = b0 << 2 & 0xFC | b2 >>> 4 & 3;
            if (len > 2) {
                b0 = b2;
                b2 = dst[bs[si++] & 0xFF];
                buffer[buflen++] = b0 << 4 & 0xF0 | b2 >>> 2 & 0xF;
                if (len > 3) {
                    b0 = b2;
                    b2 = dst[bs[si++] & 0xFF];
                    buffer[buflen++] = b0 << 6 & 0xC0 | b2 & 0x3F;
                }
            }
            len = bs.length - si;
        }
        int[] bt = new int[buflen];
        System.arraycopy(buffer, 0, bt, 0, buflen);
        return bt;
    }

    public static String encode(String name) {
        try {
            StringBuffer buffer = null;
            OutputStream encoderSink = null;
            char[] chars = name.toCharArray();
            boolean encoding = false;
            for (int i = 0; i < chars.length; ++i) {
                int j;
                char c = chars[i];
                if (c == '&') {
                    if (buffer == null) {
                        buffer = new StringBuffer();
                        for (j = 0; j < i; ++j) {
                            buffer.append(chars[j]);
                        }
                    }
                    buffer.append('&');
                    buffer.append('-');
                }
                if (c < '\u001f' || c > '\u007f') {
                    if (buffer == null) {
                        buffer = new StringBuffer();
                        for (j = 0; j < i; ++j) {
                            buffer.append(chars[j]);
                        }
                        encoderSink = new ByteArrayOutputStream();
                    }
                    if (!encoding) {
                        ((ByteArrayOutputStream)encoderSink).reset();
                        buffer.append('&');
                        encoding = true;
                    }
                    ((ByteArrayOutputStream)encoderSink).write(c / 256);
                    ((ByteArrayOutputStream)encoderSink).write(c % 256);
                    continue;
                }
                if (encoding) {
                    encoderSink.flush();
                    byte[] encoded = UTF7imap.encode(((ByteArrayOutputStream)encoderSink).toByteArray());
                    buffer.append(new String(encoded, US_ASCII));
                    buffer.append('-');
                    encoding = false;
                    if (c == '-') continue;
                    buffer.append(c);
                    continue;
                }
                if (buffer == null) continue;
                buffer.append(c);
            }
            if (encoding) {
                encoderSink.flush();
                byte[] encoded = UTF7imap.encode(((ByteArrayOutputStream)encoderSink).toByteArray());
                buffer.append(new String(encoded, US_ASCII));
                buffer.append('-');
            }
            if (buffer != null) {
                return buffer.toString();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        return name;
    }

    public static String decode(String name) {
        StringBuffer buffer = null;
        ByteArrayOutputStream decoderSink = null;
        char[] chars = name.toCharArray();
        boolean encoded = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '&') {
                if (buffer == null) {
                    buffer = new StringBuffer();
                    decoderSink = new ByteArrayOutputStream();
                    for (int j = 0; j < i; ++j) {
                        buffer.append(chars[j]);
                    }
                }
                decoderSink.reset();
                encoded = true;
                continue;
            }
            if (c == '-' && encoded) {
                if (decoderSink.size() == 0) {
                    buffer.append('&');
                } else {
                    int[] decoded = UTF7imap.decode(decoderSink.toByteArray());
                    for (int j = 0; j < decoded.length - 1; j += 2) {
                        int hibyte = decoded[j];
                        int lobyte = decoded[j + 1];
                        int d = hibyte * 256 | lobyte;
                        buffer.append((char)d);
                    }
                }
                encoded = false;
                continue;
            }
            if (encoded) {
                decoderSink.write((byte)c);
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c);
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return name;
    }

    public static void main(String[] args) {
        boolean decode = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-d")) {
                decode = true;
                continue;
            }
            String ret = decode ? UTF7imap.decode(args[i]) : UTF7imap.encode(args[i]);
            StringBuffer buf = new StringBuffer(args[i]);
            buf.append(" = \"");
            buf.append(ret);
            buf.append("\"(");
            for (int j = 0; j < ret.length(); ++j) {
                if (j > 0) {
                    buf.append(' ');
                }
                char c = ret.charAt(j);
                buf.append(Integer.toString(c, 16));
            }
            buf.append(")");
            System.out.println(buf.toString());
        }
    }

    static {
        int i;
        src = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 44};
        dst = new byte[256];
        for (i = 0; i < 255; ++i) {
            UTF7imap.dst[i] = -1;
        }
        for (i = 0; i < src.length; ++i) {
            UTF7imap.dst[UTF7imap.src[i]] = (byte)i;
        }
    }
}

