/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.nntp;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jpackage.mail.inet.nntp.NNTPConnection;
import org.jpackage.mail.inet.nntp.PendingData;

public class LineIterator
implements Iterator,
PendingData {
    static final String DOT = ".";
    boolean doneRead = false;
    NNTPConnection connection;
    String current;

    LineIterator(NNTPConnection connection) {
        this.connection = connection;
    }

    void doRead() throws IOException {
        if (this.doneRead) {
            return;
        }
        String line = this.connection.read();
        this.current = DOT.equals(line) ? null : line;
        this.doneRead = true;
    }

    public boolean hasNext() {
        try {
            this.doRead();
        }
        catch (IOException e) {
            return false;
        }
        return this.current != null;
    }

    public Object next() {
        try {
            return this.nextLine();
        }
        catch (IOException e) {
            throw new NoSuchElementException("I/O error: " + e.getMessage());
        }
    }

    public String nextLine() throws IOException {
        this.doRead();
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        this.doneRead = false;
        return this.current;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void readToEOF() throws IOException {
        do {
            this.doRead();
        } while (this.current != null);
    }
}

