/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.util;

import java.io.UnsupportedEncodingException;

public final class BASE64 {
    private static final byte[] src;
    private static final byte[] dst;

    private BASE64() {
    }

    public static byte[] encode(byte[] bs) {
        int ti = 0;
        byte[] bt = new byte[(bs.length + 2) * 4 / 3];
        for (int si = 0; si < bs.length; si += 3) {
            byte b2;
            byte b1;
            int buflen = bs.length - si;
            if (buflen == 1) {
                byte b = bs[si];
                int i = 0;
                boolean flag = false;
                bt[ti++] = src[b >>> 2 & 0x3F];
                bt[ti++] = src[(b << 4 & 0x30) + (i >>> 4 & 0xF)];
                continue;
            }
            if (buflen == 2) {
                b1 = bs[si];
                b2 = bs[si + 1];
                int i = 0;
                bt[ti++] = src[b1 >>> 2 & 0x3F];
                bt[ti++] = src[(b1 << 4 & 0x30) + (b2 >>> 4 & 0xF)];
                bt[ti++] = src[(b2 << 2 & 0x3C) + (i >>> 6 & 3)];
                continue;
            }
            b1 = bs[si];
            b2 = bs[si + 1];
            byte b3 = bs[si + 2];
            bt[ti++] = src[b1 >>> 2 & 0x3F];
            bt[ti++] = src[(b1 << 4 & 0x30) + (b2 >>> 4 & 0xF)];
            bt[ti++] = src[(b2 << 2 & 0x3C) + (b3 >>> 6 & 3)];
            bt[ti++] = src[b3 & 0x3F];
        }
        if (ti < bt.length) {
            byte[] tmp = new byte[ti];
            System.arraycopy(bt, 0, tmp, 0, ti);
            bt = tmp;
        }
        return bt;
    }

    public static byte[] decode(byte[] bs) {
        int srclen;
        for (srclen = bs.length; srclen > 0 && bs[srclen - 1] == 61; --srclen) {
        }
        byte[] buffer = new byte[srclen];
        int buflen = 0;
        int si = 0;
        int len = srclen - si;
        while (len > 0) {
            byte b0 = dst[bs[si++] & 0xFF];
            byte b2 = dst[bs[si++] & 0xFF];
            buffer[buflen++] = (byte)(b0 << 2 & 0xFC | b2 >>> 4 & 3);
            if (len > 2) {
                b0 = b2;
                b2 = dst[bs[si++] & 0xFF];
                buffer[buflen++] = (byte)(b0 << 4 & 0xF0 | b2 >>> 2 & 0xF);
                if (len > 3) {
                    b0 = b2;
                    b2 = dst[bs[si++] & 0xFF];
                    buffer[buflen++] = (byte)(b0 << 6 & 0xC0 | b2 & 0x3F);
                }
            }
            len = srclen - si;
        }
        byte[] bt = new byte[buflen];
        System.arraycopy(buffer, 0, bt, 0, buflen);
        return bt;
    }

    public static void main(String[] args) {
        boolean decode = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-d")) {
                decode = true;
                continue;
            }
            try {
                byte[] in = args[i].getBytes("US-ASCII");
                byte[] out = decode ? BASE64.decode(in) : BASE64.encode(in);
                System.out.println(args[i] + " = " + new String(out, "US-ASCII"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    static {
        int i;
        src = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        dst = new byte[256];
        for (i = 0; i < 255; ++i) {
            BASE64.dst[i] = -1;
        }
        for (i = 0; i < src.length; ++i) {
            BASE64.dst[BASE64.src[i]] = (byte)i;
        }
    }
}

