/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.security.sasl.SaslClient;

public class SaslInputStream
extends FilterInputStream {
    private final SaslClient sasl;
    private byte[] buf;
    private int pos;

    public SaslInputStream(SaslClient sasl, InputStream in) {
        super(in);
        this.sasl = sasl;
    }

    public int read() throws IOException {
        if (this.buf != null) {
            byte c = this.buf[this.pos++];
            if (this.pos == this.buf.length) {
                this.buf = null;
            }
            return c;
        }
        int c = super.read();
        if (c == -1) {
            return c;
        }
        byte[] bytes = new byte[1];
        byte[] unwrapped = this.sasl.unwrap(bytes, 0, 1);
        c = unwrapped[0];
        if (unwrapped.length > 1) {
            int l = unwrapped.length - 1;
            this.buf = new byte[l];
            System.arraycopy(unwrapped, 1, this.buf, 0, l);
            this.pos = 0;
        }
        return c;
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        if (this.buf != null) {
            int l = this.buf.length;
            if (l - this.pos <= len) {
                System.arraycopy(this.buf, this.pos, bytes, off, l);
                this.buf = null;
                return l;
            }
            System.arraycopy(this.buf, this.pos, bytes, off, len);
            this.pos += len;
            return len;
        }
        int l = super.read(bytes, off, len);
        if (l == -1) {
            return l;
        }
        byte[] unwrapped = this.sasl.unwrap(bytes, off, l);
        int l2 = unwrapped.length;
        if (l2 > len) {
            int d = l2 - len;
            this.buf = new byte[d];
            System.arraycopy(unwrapped, 0, bytes, off, len);
            System.arraycopy(unwrapped, len, this.buf, 0, d);
            this.pos = 0;
            return len;
        }
        System.arraycopy(unwrapped, 0, bytes, off, l2);
        for (int i = l2; i < l; ++i) {
            bytes[off + l2] = 0;
        }
        return l2;
    }
}

