/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.util;

import java.io.UnsupportedEncodingException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class SaslLogin
implements SaslClient {
    private static final int STATE_USERNAME = 0;
    private static final int STATE_PASSWORD = 1;
    private static final int STATE_COMPLETE = 2;
    private String username;
    private String password;
    private int state;

    public SaslLogin(String username, String password) {
        this.username = username;
        this.password = password;
        this.state = 0;
    }

    public String getMechanismName() {
        return "LOGIN";
    }

    public boolean hasInitialResponse() {
        return false;
    }

    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        try {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    return this.username.getBytes("UTF-8");
                }
                case 1: {
                    this.state = 2;
                    return this.password.getBytes("UTF-8");
                }
            }
            return new byte[0];
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The UTF-8 character set is not supported by the VM";
            throw new SaslException(msg, e);
        }
    }

    public boolean isComplete() {
        return this.state == 2;
    }

    public byte[] unwrap(byte[] incoming, int off, int len) throws SaslException {
        byte[] ret = new byte[len - off];
        System.arraycopy(incoming, off, ret, 0, len);
        return ret;
    }

    public byte[] wrap(byte[] outgoing, int off, int len) throws SaslException {
        byte[] ret = new byte[len - off];
        System.arraycopy(outgoing, off, ret, 0, len);
        return ret;
    }

    public Object getNegotiatedProperty(String name) {
        return null;
    }

    public void dispose() {
    }
}

