/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.util;

import java.io.UnsupportedEncodingException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class SaslPlain
implements SaslClient {
    private String username;
    private String password;
    private boolean complete;

    public SaslPlain(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getMechanismName() {
        return "PLAIN";
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        try {
            byte[] a = this.username.getBytes("UTF-8");
            byte[] b = this.password.getBytes("UTF-8");
            byte[] c = new byte[a.length * 2 + b.length + 2];
            System.arraycopy(a, 0, c, 0, a.length);
            System.arraycopy(a, 0, c, a.length + 1, a.length);
            System.arraycopy(b, 0, c, a.length * 2 + 2, b.length);
            this.complete = true;
            return c;
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Username or password contains illegal UTF-8";
            throw new SaslException(msg, e);
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public byte[] unwrap(byte[] incoming, int off, int len) throws SaslException {
        byte[] ret = new byte[len - off];
        System.arraycopy(incoming, off, ret, 0, len);
        return ret;
    }

    public byte[] wrap(byte[] outgoing, int off, int len) throws SaslException {
        byte[] ret = new byte[len - off];
        System.arraycopy(outgoing, off, ret, 0, len);
        return ret;
    }

    public Object getNegotiatedProperty(String name) {
        return null;
    }

    public void dispose() {
    }
}

